% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equiv_tost.R
\name{equiv_tost}
\alias{equiv_tost}
\title{equiv_tost}
\arguments{
\item{data}{Data frame contains raw data. Must contain a column with a population identifier (e.g. population ID), and a column containing critical
thermal limit data (e.g. temperatures at which critical limits are reached).}

\item{groups_col}{Factor. Column containing the name of the population of interest (group ID)}

\item{groups_which}{Character. Which population should be analysed?}

\item{response}{Numeric. Column containing thermal limit data for individual samples}

\item{skews}{Numeric. Vector containing skewness parameter(s). Defaults to 0, 1, 2, 10, 50.}

\item{equiv_margin}{Numeric. Equivalence of subsets to full population CT estimate (unit = degree Celcius). Defaults to 1.}

\item{pop_n}{Numeric. Size of population to sample (will test subsamples of size pop_n - x against pop_n for equivalence) Defaults to population size = 30}

\item{colrs}{Character. Vector of colours for each skewness paramater value. E.g. if two skewness parameter values are set, choose two colours: colrs = c("blue", "red").
Defaults to "blue", "red", "orange", "forestgreen", "lightgrey".}
}
\value{
Two plots; (a) equivalence of means, and (b) equivalence of variances
}
\description{
Perform a Test of Total Equivalence as adapted from Duffy et al. (2021) (<https://doi.org/10.1111/1365-2435.13928>)
}
\examples{
\donttest{
head(coreid_data)
res <- equiv_tost(data = coreid_data,
                    groups_col = col,
                    groups_which = "Catorhintha schaffneri_APM",
                    response = response,
                    skews = c(1,10),
                    colrs = c("lightblue", "lightpink"),
                    equiv_margin = 1,
                    pop_n = 5)
}
}
