% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToxicoSet.R
\name{subsetTo}
\alias{subsetTo}
\title{A function to subset a ToxicoSet to data containing only specified drugs, cells and genes}
\usage{
subsetTo(
  tSet,
  cell_lines = NULL,
  drugs = NULL,
  molecular.data.cells = NULL,
  duration = NULL,
  features = NULL,
  ...
)
}
\arguments{
\item{tSet}{A \code{ToxicoSet} to be subsetted}

\item{cell_lines}{A list or vector of cell names as used in the dataset to which
the object will be subsetted. If left blank, then all cells will be left in
the dataset.}

\item{drugs}{A list or vector of drug names as used in the dataset to which
the object will be subsetted. If left blank, then all drugs will be left in
the dataset.}

\item{molecular.data.cells}{A list or vector of cell names to keep in the
molecular data}

\item{duration}{A \code{list} or \code{vector} of the experimental durations
to include in the subset as strings. Defaults to all durations if parameter
is not specified.}

\item{features}{A list or vector of feature names as used in the dataset from
which the object will be subsetted. If left blank that all features will
be left in.}

\item{...}{Other arguments passed by other function within the package}
}
\value{
A ToxicoSet with only the selected drugs and cells
}
\description{
This is the prefered method of subsetting a ToxicoSet. This function allows
abstraction of the data to the level of biologically relevant objects: drugs
and cells. The function will automatically go through all of the
combined data in the ToxicoSet and ensure only the requested radiations
and cell lines are found in any of the slots. This allows quickly picking out
all the experiments for a radiation or cell of interest, as well removes the need
to keep track of all the metadata conventions between different datasets.
}
\examples{
TGGATESDrugNames  <- drugNames(TGGATESsmall)
TGGATESCells <- cellNames(TGGATESsmall)
tSet <- subsetTo(TGGATESsmall,drugs = TGGATESDrugNames[1],
  cells = TGGATESCells[1], duration = "2")

}
