% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_bindings.R
\name{set_missing_count}
\alias{set_missing_count}
\title{Set the display for missing strings}
\usage{
set_missing_count(e, f_str, string = "NA")
}
\arguments{
\item{e}{A count layer}

\item{f_str}{An f_str object to change the display of the missing counts}

\item{string}{A named string representing the value to rename missing values
This value can be named to change the row name in the table.}
}
\value{
The modified layer
}
\description{
If there is a special way NA or missing values should be counted, this binding
will display the values in a different way.
}
\examples{
library(magrittr)
library(dplyr)
  mtcars2 <- mtcars \%>\%
mutate_all(as.character)
mtcars2[mtcars$cyl == 6, "cyl"] <- NA
mtcars2[mtcars$cyl == 8, "cyl"] <- NA

tplyr_table(mtcars2, gear) \%>\%
  add_layer(
    group_count(cyl) \%>\%
      set_missing_count(f_str("xx ", n), string = c(Missing = "NA")) \%>\%
      set_denom_ignore("Unknown", "NA")
  ) \%>\%
  build()
}
