% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testHetPerm.R
\name{testHetPerm}
\alias{testHetPerm}
\title{Permutation Test of Heterogeneity}
\usage{
testHetPerm(data, tree, source = "person", rep = 1000, nCPU = 4)
}
\arguments{
\item{data}{matrix or data frame with three columns: person code/index, item label, response category. Can also be the path to a .csv file with frequencies (comma-separated; first line defines category labels)}

\item{tree}{a list that defines which categories belong to the same multinomial distribution (i.e., the the same MPT tree). For instance: \code{tree = list(tree.old = c("hit","cr"), tree.new = c("fa","miss"))}. Category labels must match the values of the third column of \code{data}}

\item{source}{whether to test for \code{"person"} or \code{"item"} homogeneity}

\item{rep}{number of permutations to be sampled}

\item{nCPU}{number of CPUs used for parallel Monte Carlo sampling of permutations}
}
\description{
Tests whether whether participants (items) are homogeneous without assuming item (participant) homogeneity.
}
\details{
If an item/person has zero frequencies on all categories in an MPT tree, these zeros are neglected when computing mean frequencies per column. As an example, consider a simple recognition test with a fixed assignments of words to the learn/test list. In such an experiment, all learned words will result in hits or misses (i.e., the MPT tree of old items), whereas new words are always false alarms/correct rejections and thus belong to the MPT tree of new items (this is not necessarily the case if words are assigned randomly).

Note that the test does still assume independence of observations. However, it does not require item homogeneity when testing participant heterogeneity (in contrast to the chi-square test: \code{\link{testHetChi}}).
}
\examples{
# generate homogeneous data
# (N=15 participants, M=30 items)
data <- data.frame(id = rep(1:15, each=30),
                   item = rep(1:30, 15))
data$cat <- sample(c("h","cr","m","fa"),15*30,
                   replace = TRUE,
                   prob = c(.7,.3,.4,.6))
head(data)
tree <- list(old = c("h","m"),
             new = c("fa", "cr"))

# test participant homogeneity:
tmp <- testHetPerm(data, tree, rep=200, nCPU=1)
tmp[2:3]
}
\references{
Smith, J. B., & Batchelder, W. H. (2008). Assessing individual differences in categorical data. Psychonomic Bulletin & Review, 15, 713-731. \doi{10.3758/PBR.15.4.713}
}
\seealso{
\code{\link{testHetChi}}, \code{\link{plotFreq}}
}
\author{
Daniel W. Heck
}
