mytree.symmetric.taxa <-
function (m, distributionspname, distributionspparameters, distributionextname, distributionextparameters, complete=TRUE, labellivingsp="sp.", labelextinctsp="ext.")
{

udistributionspparameters <- capture.output (cat(distributionspparameters, sep=","))
udistributionextparameters <- capture.output (cat(distributionextparameters, sep=","))
rnumbsp <- parse(text=paste(distributionspname, "(1,", udistributionspparameters,")"))
rnumbext <- parse(text=paste(distributionextname, "(1,", udistributionextparameters,")"))

# tracing back the time for one species until origin
trajectory  <- function (trace){
	#trace should indicate the edge number that is to be followed until the origin
	trajectory  <- NULL
	while ( length( which(edge[,2] == trace)) ){
		atual  <- which(edge[,2] == trace)
		trajectory  <- c(edge.length[atual], trajectory)
		trace  <- edge[atual,1]
	}
  	return(trajectory)
  }
bingo <- FALSE

while (bingo == FALSE)	# ######## while bingo
{											
	stop <- FALSE
	stopsearch <- FALSE
	mytree <-list(edge=NULL, tip.label=NULL, edge.length=NULL, Nnode=NULL, root.edge=NULL)
	class(mytree) <- "phylo"
	edge <- matrix(c(-1,-2), ncol=2)
	leaves <- NULL
	realleaves <- NULL
	extinct <- NULL
	realextinct <- NULL
	age <- NULL
	timeline <- NULL
	extinct <- NULL
	tip.label <- NULL
	pnodges <- NULL
	timeline <- NULL
 
# initial if in case the (-1,-2) edge get extinct or bigger than age
spt <- eval(rnumbsp)
#to remove NaN warnings messages
{
if (distributionextparameters[1] == 0)
{
	extt <- suppressWarnings(eval(rnumbext))
}
else
{
	extt <- eval(rnumbext)
}
}
# if to see if the user simulates with extinction = ZERO and avoid error generated by expression-distribution when rate equals zero
{
if (is.nan(extt))
{
	extt <- spt +1 # we add so that the sp will always occurs first, and an extinction will never occur
}
}

{
if (spt <= extt)
{
	status <- "sp" #occurred an speciation
	edge.length <- spt
	leaves <- -2
}
else
{
	status <- "ext" #occurred an extinction
	edge.length <- extt
	extinct <- -2
	stop <- TRUE
}
}
	pnodges <- c(leaves, extinct)	
	timeline <- edge.length[1]
# for the while (increase of the tree)
while (stop == FALSE) 
{
	stopsearch <- FALSE
	positionnextsp <- which(timeline == min(timeline))[1] #ATTENTION, we take the first element since it can happen that we get two equal numbers
	nextsp <- min(edge[,2])
	species <- pnodges[positionnextsp]
	ptime <- timeline[positionnextsp]
	pnodges <- pnodges[-positionnextsp]
	timeline <- timeline[-positionnextsp]
	i <- 1
	for (i in 1:2)
	{ 
		edge <- rbind( edge, c(species, (nextsp - i)))
		spt <- eval(rnumbsp)
		#to remove NaN warnings messages
		{
		if (distributionextparameters[1] == 0)
		{
			extt <- suppressWarnings(eval(rnumbext))
		}
		else
		{
			extt <- eval(rnumbext)
		}
		}
		# if to see if the user simulates with extinction = ZERO and avoid error generated by exp. distribution when rate equals zero
		{
		if (is.nan(extt))
		{
			extt <- spt +1 # we add so that the sp will always occurs first, and we will never have an extinction
		}
		}
		
		{
		if (spt <= extt)
		{
			status <- "sp" #occurred an speciation
			edge.length <- c(edge.length, spt)
			leaves <- c(leaves, (nextsp - i))
			ntime <- spt
		}
		else
		{
			status <- "ext" #occurred an extinction
			edge.length <- c(edge.length, extt)
			extinct <- c(extinct, (nextsp - i))
			ntime <- extt
		}
		}
		pnodges <- c(pnodges, (nextsp - i))
		timeline <- c(timeline, (ptime + ntime))
	}
	leaves <- leaves[-1]
	
	#now we test for the smallest pnodge and see if there is the enough leaving creatures
	while (stopsearch == FALSE)
	{
		{
		if (length(pnodges) == 0)
		{
			stop <- TRUE	
			stopsearch <- TRUE
		}
		else
		{	
		
			{
			if (length(pnodges) >= m)
			{
				#we achieved m species at least
				bingo<- TRUE
				stop <- TRUE
				stopsearch <- TRUE
				age <- min(timeline)
				realleaves <- pnodges
			}
			else
			{
				positionsp <- which(timeline == min(timeline))[1]
				#testing fit the smallest tested one is an extinct
				{
				if (pnodges[positionsp] %in% extinct)
				{
					#if it is on the extinct, we will remove it from the pnodges and timeline and add it to the realextinct
					realextinct <- c(realextinct, pnodges[positionsp])
					pnodges <- pnodges[-positionsp]
					timeline <- timeline[-positionsp]
				}
				else
				{
					stopsearch <- TRUE
				}
				}
			}
			}
		}
		}	
	}

}
 
}# ######## while bingo finish
    
# after this point, all threes that are leaving this last while have at least m leavingspecies....
extinct <- realextinct

#cutting tree at desired age
step <- 1
for (step in 1: length(pnodges))
{
	traject <- trajectory(pnodges[step])
	traject <- traject[-length(traject)]
	edge.length[which(edge[,2]==pnodges[step])] <- (age-sum(traject))
}

# final if... in case of (stop == TRUE) , we write the tree "mytree"
{
if (stop == TRUE) 
{
	#### replacing to the ape format
	prealleaves <- realleaves
	{
	if (length(realleaves) > 0)
	{
			realleaves <- c(1:length(realleaves))
			i <- 1
			for (i in 1:length(realleaves))
			{
					edge[ which(edge[,2] == prealleaves[i]), 2 ] <- realleaves[i]
			}
	tip.label <- paste(labellivingsp, realleaves, sep = "")
      	}
      	}
	pextinct <- extinct
	{
      	if (length(extinct) > 0)
      	{
		extinct <- c((length(realleaves)+1):(length(realleaves)+length(extinct)))
		i <- 1
		for (i in 1:length(extinct))
		{
				edge[ which(edge[,2] == pextinct[i]), 2 ] <- extinct[i]
		}
	tip.label <- c(tip.label, paste(labelextinctsp, extinct, sep = "") )
	}
	}
	#regarding the edges that lead to an extinct or leaving final species, but are not the final edges
	potheredges <- levels(as.factor(edge[edge <0]))
	otheredges <- rev(seq((max(realleaves, extinct)+1), length.out=length(potheredges)))
	#substituting...
	i <- 1
	for (i in 1:length(potheredges))
	{
		edge[ edge == potheredges[i] ] <- otheredges[i]
	}
	mytree$edge <- edge	
	mytree$tip.label <- tip.label
	mytree$edge.length <- edge.length
	mytree$Nnode <-  length(realleaves) + length(extinct)
	mytree$root.edge <- edge.length[1]
}	
}

#final handling’s before plotting with ape
{
if (length(realleaves) == 0)
{
	# in case no specie is surviving until final simulation time
	mytree <- 0
}
else
{
	{
	if ( length(realleaves) == 1 & complete == FALSE)
	{
		#in case only one specie is surviving, even if other speciations events occured in the history
		mytree <- 1
	}
	else
	{
		{
		if (length(realleaves)==1 & length(extinct)==0 & complete==TRUE)
		{
			#in case only one species is surviving and was the only one that existed
			mytree <- 1
		}
		else
		{
			#in case non of the above condition is fulfilled, there will be a tree with no initial branch, tree starts at the MRCA
			#this is done to be aple to plot and be compatible wth `ape` package 
			mytree <- collapse.singles(mytree)
			#cheking status of 'complete' and take or dont take extincted species out of final tree
			{
			if (complete == FALSE)	
			{
				mytree<- drop.fossil(mytree)
			}
			}		
		}
		}		
	}
	}	
}
}
#mytree
return(mytree)
}
