% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RoguePlot.R
\name{RoguePlot}
\alias{RoguePlot}
\title{Visualize position of rogue taxa}
\usage{
RoguePlot(
  trees,
  tip,
  p = 1,
  plot = TRUE,
  Palette = colorRampPalette(c(par("fg"), "#009E73"), space = "Lab"),
  nullCol = rgb(colorRamp(unlist(par(c("fg", "bg"))), space = "Lab")(0.8)/255),
  edgeLength = NULL,
  thin = par("lwd"),
  fat = thin + 1L,
  outgroupTips,
  ...
)
}
\arguments{
\item{trees}{List or \code{multiPhylo} object containing phylogenetic trees
of class \code{phylo} to be summarized.}

\item{tip}{Numeric or character identifying rogue leaf, in format accepted
by \code{\link[=DropTip]{DropTip()}}.}

\item{p}{A numeric value between 0.5 and 1 giving the proportion for a clade
to be represented in the consensus tree (see \code{\link[=Consensus]{Consensus()}}).}

\item{plot}{Logical specifying whether to plot the tree.}

\item{Palette}{Function that takes a parameter \code{n} and generates a colour
palette with \code{n} entries.}

\item{nullCol}{Colour to paint regions of the tree on which the rogue is
never found.}

\item{edgeLength}{Numeric specifying edge lengths of consensus tree;
\code{NULL} aligns tips by scaling edges proportional to clade size; \code{1} sets
all edges to unit length.}

\item{thin, fat}{Numeric specifying width to plot edges if the rogue tip
never / sometimes does attach to them.}

\item{outgroupTips}{Vector of type character, integer or logical, specifying
the names or indices of the tips to include in the outgroup.  If
\code{outgroupTips} is a of type character, and a tree contains multiple tips
with a matching label, the first will be used.}

\item{\dots}{Additional parameters to \code{plot.phylo()}.}
}
\value{
\code{RoguePlot()} returns a list whose elements are:
\itemize{
\item \code{cons}: The reduced consensus tree, in preorder;
\item \code{onEdge}: a vector of integers specifying the number of
trees in \code{trees} in which the rogue leaf is attached to each edge in turn
of the consensus tree;
\item \code{atNode}: a vector of integers specifying the number of trees in \code{trees}
in which the rogue leaf is attached to an edge collapsed into each node
of the consensus tree.
}
}
\description{
Plots a consensus of trees with a rogue taxon omitted, with edges coloured
according to the proportion of trees in which the taxon attaches to that
edge, after \insertCite{Klopfstein2019;textual}{TreeTools}.
}
\details{
Rogue taxa can be identified using the package \pkg{Rogue}
\insertCite{SmithCons}{TreeTools}.
}
\examples{
trees <- list(read.tree(text = '(a, (b, (c, (rogue, (d, (e, f))))));'),
              read.tree(text = '(a, (b, (c, (rogue, (d, (e, f))))));'),
              read.tree(text = '(a, (b, (c, (rogue, (d, (e, f))))));'),
              read.tree(text = '(a, (b, (c, (rogue, (d, (e, f))))));'),
              read.tree(text = '(rogue, (a, (b, (c, (d, (e, f))))));'),
              read.tree(text = '((rogue, a), (b, (c, (d, (e, f)))));'),
              read.tree(text = '(a, (b, ((c, d), (rogue, (e, f)))));'),
              read.tree(text = '(a, (b, ((c, (rogue, d)), (e, f))));'),
              read.tree(text = '(a, (b, (c, (d, (rogue, (e, f))))));'))
RoguePlot(trees, 'rogue')
}
\references{
\insertAllCited{}
}
\seealso{
Other consensus tree functions: 
\code{\link{ConsensusWithout}()},
\code{\link{Consensus}()}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{consensus tree functions}
