% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylo.R
\name{SingleTaxonTree}
\alias{SingleTaxonTree}
\title{Generate a single taxon tree}
\usage{
SingleTaxonTree(label)
}
\arguments{
\item{label}{a character vector specifying the label of the tip.}
}
\value{
\code{SingleTaxonTree()} returns a \code{phylo} object containing a single
tip with the specified label.
}
\description{
\code{SingleTaxonTree()} creates a phylogenetic 'tree' that contains a single
taxon.
}
\examples{
SingleTaxonTree('Homo_sapiens')
plot(SingleTaxonTree('root') + BalancedTree(4))

}
\seealso{
Other tree manipulation: 
\code{\link{AddTip}()},
\code{\link{CollapseNode}()},
\code{\link{ConsensusWithout}()},
\code{\link{DropTip}()},
\code{\link{EnforceOutgroup}()},
\code{\link{ImposeConstraint}()},
\code{\link{KeptPaths}()},
\code{\link{KeptVerts}()},
\code{\link{LeafLabelInterchange}()},
\code{\link{MakeTreeBinary}()},
\code{\link{RenumberTips}()},
\code{\link{RenumberTree}()},
\code{\link{Renumber}()},
\code{\link{RootTree}()},
\code{\link{SortTree}()},
\code{\link{Subtree}()}

Other tree generation functions: 
\code{\link{ConstrainedNJ}()},
\code{\link{GenerateTree}},
\code{\link{NJTree}()},
\code{\link{TreeNumber}}
}
\concept{tree generation functions}
\concept{tree manipulation}
\keyword{tree}
