% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_pancan_value.R
\name{vis_toil_TvsN}
\alias{vis_toil_TvsN}
\title{Visualize single gene expression from toil data hub}
\usage{
vis_toil_TvsN(
  Gene = "TP53",
  Mode = "Boxplot",
  Show.P.value = TRUE,
  Show.P.label = TRUE,
  Method = "wilcox.test",
  values = c("#DF2020", "#DDDF21")
)
}
\arguments{
\item{Gene}{Gene symbal for comparision}

\item{Mode}{Boxplot or Violinplot to represent data}

\item{Show.P.value}{TRUE or FALSE whether to count P value}

\item{Show.P.label}{TRUE or FALSE present p value with number or label '* ** *** ****'}

\item{Method}{default method is wilcox.test}

\item{values}{the color to fill tumor or normal}
}
\value{
a \code{ggplot} object
}
\description{
Visualize single gene expression from toil data hub
}
\examples{
\donttest{
p <- vis_toil_TvsN(Gene = "TP53", Mode = "Violinplot", Show.P.value = F, Show.P.label = F)
p <- vis_toil_TvsN(Gene = "TP53", Mode = "Boxplot", Show.P.value = F, Show.P.label = F)
}
}
