% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_value.R
\name{query_molecule_value}
\alias{query_molecule_value}
\title{Get Molecule or Signature Data Values from Dense (Genomic) Matrix Dataset of UCSC Xena Data Hubs}
\usage{
query_molecule_value(dataset, molecule, host = NULL)
}
\arguments{
\item{dataset}{a UCSC Xena dataset in dense matrix format (rows are features
(e.g., gene, cell line) and columns are samples).}

\item{molecule}{a molecular identifier (e.g., "TP53") or a formula specifying
genomic signature (\code{"TP53 + 2 * KRAS - 1.3 * PTEN"}).
\strong{NOTE}, when a signature is specified, a space must exist in the input.}

\item{host}{a UCSC Xena host, default is \code{NULL}, auto-detect from the dataset.}
}
\value{
a named vector.
}
\description{
Get Molecule or Signature Data Values from Dense (Genomic) Matrix Dataset of UCSC Xena Data Hubs
}
\examples{
# What does dense matrix mean?
table(UCSCXenaTools::XenaData$Type)
# It is a the UCSC Xena dataset with "Type" equals to "genomicMatrix"
\dontrun{
dataset <- "ccle/CCLE_copynumber_byGene_2013-12-03"
x <- query_molecule_value(dataset, "TP53")
head(x)

signature <- "TP53 + 2*KRAS - 1.3*PTEN" # a space must exist in the string
y <- query_molecule_value(dataset, signature)
head(y)
}
}
