% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{MonthlyStats}
\alias{MonthlyStats}
\title{Monthly Statistics}
\usage{
MonthlyStats(
  x,
  stat,
  AggStat = NULL,
  Plot = TRUE,
  ylab = "Magnitude",
  main = "Monthly Statistics",
  col = "grey"
)
}
\arguments{
\item{x}{a data.frame with Dates or POSIXct in the first column and numeric vector in the second.}

\item{stat}{the function of interest. mean or sum for example.}

\item{AggStat}{the aggregating statistic. The default is mean. See details}

\item{Plot}{logical argument with a default of TRUE. If TRUE the monthly statistics are plotted.}

\item{ylab}{A label for the y axis of the plot. The default is "Magnitude"}

\item{main}{A title for the plot. The default is "Monthly Statistics"}

\item{col}{A choice of colour for the bar plot. A single colour or a vector (a colour for each bar).}
}
\value{
A list with two elements. The first element is a data.frame with year in the first column and months in the next 12 (i.e. each row has the monthly stats for the year). The second element is a dataframe with month in the first column and the associated aggregated statistic in the second. i.e. the aggregated statistic (default is the mean) for each month is provided.
}
\description{
Derives monthly statistics from a data.frame with Dates or POSIXct in the first column and variable of interest in the second
}
\details{
The statistic of interest for each month is calculated for each calendar year in the data.frame. An aggregated result is also calculated for each month using an aggregating statistic (the mean by default). The data.frame is first truncated at the first occurrence of January 1st and last occurrence of December 31st.
}
\examples{
# Get the mean flows for each month for the Thames at Kingston
QMonThames <- MonthlyStats(ThamesPQ[,c(1,3)], stat = mean,
ylab = "Discharge (m3/s)", main = "Thames at Kingston monthly mean flow")
# Get the monthly sums of rainfall for the Thames at Kingston
PMonThames <- MonthlyStats(ThamesPQ[,c(1,2)], stat = sum,
ylab = "Rainfall (mm)", main = "Thames as Kingston monthly rainfall")
}
\author{
Anthony Hammond
}
