% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{NonFloodAdj}
\alias{NonFloodAdj}
\title{Non-flood adjustment}
\usage{
NonFloodAdj(x)
}
\arguments{
\item{x}{The annual maximum sample. Numeric vector}
}
\value{
A list is returned. The first element of the list is a dataframe with one row and two columns. Lcv in the first column and Lskew in the second. The second element of the list is another dataframe with one row and three columns. Number of non-flood years in the first column, sample size in the second and the percent of non-flood year in the third.
}
\description{
Adjusts the linear coefficient of variation (Lcv) and the linear skewness to account for non-flood years
}
\details{
The method is the “permeable adjustment method” detailed in chapter 19, volume three of the Flood Estimation Handbook, 1999. The method makes no difference for sites where there are no annual maximums (AM) in the sample that are < median(AM)/2. Once applied the results can be used with the LRatioChange function to update the associated member of a pooling group. There is also the NonFloodAdjPool() function which can be used for multiple sites in a pooling group.
}
\examples{
# Get an anuual maximum sample with a BFIHOST above 0.65 and with some
# annual maximums lower than median(AM)/2. And then apply the function.
NonFloodAdj(GetAM(44013)[,2])
}
\author{
Anthony Hammond
}
