% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{CDsXML}
\alias{CDsXML}
\title{Import catchment descriptors from .xml files}
\usage{
CDsXML(x)
}
\arguments{
\item{x}{the xml file path}
}
\value{
A data.frame with columns; Descriptor and Value.
}
\description{
Imports catchment descriptors from xml files either from an FEH webservice download or from the Peakflows dataset downloaded from the national river flow archive (NRFA) website
}
\details{
File paths for importing data require forward slashes. On some operating systems, such as windows, the copy and pasted file paths will have backward slashes and would need to be changed accordingly.
}
\examples{
#Import catchment descriptors from a NRFA peakflows xml file and display in console
\dontrun{CDs.4003 <- CDsXML("C:/Data/NRFAPeakFlow_v11/Suitable for QMED/4003.xml")}
\dontrun{CDs.4003}
#Import catchment descriptors from a FEH webserver xml file and display xml in the console
\dontrun{CDs.MySite <- CDsXML("C:/Data/FEH_Catchment_384200_458200.xml")}
}
\author{
Anthony Hammond
}
