% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.VEwaningVariant.R
\name{plot}
\alias{plot}
\alias{plot.VEwaningVariant}
\title{Plot Analysis Results}
\usage{
\method{plot}{VEwaningVariant}(x, y, ..., times = NULL, xlim = NULL, nTimes = 20L, ylim = NULL)
}
\arguments{
\item{x}{An object of class VEwaningVariant. The object returned by a call to
veWaningVariant()}

\item{y}{Ignored}

\item{...}{Ignored}

\item{times}{A numeric vector object or NULL. The times since full
efficacy at which the vaccine efficacy is to be estimated. If NULL, the
times will be generated internally as a vector of length nTimes spanning
the range [0, maxTime], where maxTime is the maximum time since vaccination  
present in the original analysis. Values provided outside of [0, maxTime] 
are ignored.}

\item{xlim}{A numeric vector object of length 2 or NULL. The extrema
of the times values at which estimates are to be calculated. A vector of 
length nTimes spanning the range [xlim[1], xlim[2]] is generated. Note 
that the specified limits must lie in the range [0, maxTime]. If input 
times is a vector object, this input is ignored.}

\item{nTimes}{An integer object. The number of time values at which
estimates are obatined. The default is 20. If input times is a vector
object, this input is ignored.}

\item{ylim}{A numeric vector object or NULL. The y-axis limits for the plots.
If NULL, the y-axis limits are taken from the estimated values.}
}
\value{
A gg object.
}
\description{
Plot the Estimated Vaccine Efficacy
}
\details{
When the variant under analysis is present only in the unblinded phase, 
  vaccine efficacy cannot be estimated. In this case, plot() shows the  
  relative infection rate at times t since full efficacy reached, defined  
  as infection rate at time t = time since full efficacy reached  
  divided by the infection rate at the time full efficacy is reached (t=0).
}
\examples{
data(variantData)

set.seed(1234)

ind <- sample(1:nrow(x = variantData), 2000, FALSE)

# NOTE: This sample size is chosen for example only -- larger data sets
# should be used.

res <- veWaningVariant(data = variantData[ind,], 
                       L = 52,  
                       lag = 6,
                       gFunc = 'piece', 
                       v = c(15,30))

plot(x = res)
}
