% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{forest_visitation}
\alias{forest_visitation}
\title{National Forest Visitation Photo-User-Days Data.}
\format{
A data frame with 995 observations and 4 variables.

\describe{
  \item{date}{Date of monthly observation, in year-month-day format.}
  \item{forest}{National Forest 3 letter identifier code, except for San Juan County which is labled as SJC.}
  \item{pud}{Flickr photo-user-days (PUD). Here, PUD count the number of unique users posting a photo on flickr on a given day from within the boundaries of a given National Forest.}
  \item{nfs}{Annual Visitation count for the corresponding forest and year given by the National Forest Service (NFS) and then distributed monthly utilizing the PUD as a proxy.}
}
}
\source{
Flickr (2022). Retrieved August, 2022, from https://flickr.com/
}
\usage{
forest_visitation
}
\description{
A data frame storing monthly visitation counts by National Forest Service (NFS) for 4 popular US national parks and associated Flickr photo-user-days (PUD).
Here, photo-user-days (PUD) count the number of unique users posting a photo on Flickr on a given day from within the boundaries of a given National Forest.
}
\keyword{datasets}
