% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AddSources.R
\name{AddSources}
\alias{AddSources}
\title{AddSources}
\usage{
AddSources(server, username, password, sources)
}
\arguments{
\item{server}{The URL of the web service ending with /services or with ?wsdl,
for example: http://worldwater.byu.edu/app/index.php/default/services/cuahsi_1_1.asmx?wsdl
alternatively you can specify the JSON API url like:
http://worldwater.byu.edu/app/index.php/default/services/api/}

\item{username}{The valid HydroServer Lite username, for example "admin"}

\item{password}{The valid HydroServer Lite password, for example "password"}

\item{sources}{The valid table of sources. This table must have the following columns:
Organization, Description, SourceLink, ContactName, ContactPhone, ContactEmail,
Address, City, State, Zipcode, Citation, MetadataID.}
}
\value{
A table of the added sources, with two extra columns:
SourceID (the ID assigned by the server),
Status (the status showing if the source was added: OK or Error). If the status is Error, then
the Error message with reason why the source could not be added is also shown.
}
\description{
This function adds a table of sources to HydroServer Lite.
The input must be a data.frame with all required ODM 'Source' fields
NOTE: this only works with HydroServer Lite that implements the JSON API.
you must specify a valid server url, user name, and password for the HydroServer.
The examples here use the 'sandbox' HydroServer on http://worldwater.byu.edu/app/
with the username: admin and password: password.
}
\examples{
user <- "admin"
pass <- "password"
server <- "http://worldwater.byu.edu/app/index.php/default/services/cuahsi_1_1.asmx"
#make random source codes
random_id = sample(1:10000,size=1)
random_name = paste("R test source", random_id)
my_sources <- data.frame(
  Organization = random_name,
  Description = paste("Uploaded from R:",random_name),
  SourceLink = paste("http://", random_id, sep=""),
  ContactName = random_name,
  ContactPhone = "012-345-6789",
  ContactEmail = "test<at>gmail.com",
  Address = random_name,
  City = random_name,
  State = random_name,
  Zipcode = random_id * 10,
  Citation = paste("Uploaded from R as a test:", random_name),
  MetadataID = 10
)

added_sources <- AddSources(server, username=user, password=pass,
                                sources=my_sources)
}
\keyword{waterml}

