% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MakeSOAPEnvelope.R
\name{MakeSOAPEnvelope}
\alias{MakeSOAPEnvelope}
\title{MakeSOAPEnvelope}
\usage{
MakeSOAPEnvelope(CUAHSINamespace, MethodName, parameters = NULL)
}
\arguments{
\item{CUAHSINamespace}{The SOAP namespace. This must be either "http://www.cuahsi.org/his/1.0/ws"
for WaterML 1.0, or "http://www.cuahsi.org/his/1.1/ws" for WaterML 1.1}

\item{MethodName}{The name of the WaterOneFlow web service method. It can be one of the following
values: "GetSites", "GetSitesObject", "GetSitesByBoxObject", "GetSiteInfoObject",
"GetVariablesObject", "GetValuesObject"}

\item{parameters}{An optional vector of named parameters for the web method. For GetSites,
GetSitesObject and GetVariables no parameters are required. For GetSiteInfoObject you need the
"site" parameter. For GetValuesObject you need the "location", "variable", "startDate" and "endDate"
parameters.}
}
\value{
A <soap:Envelope> text in XML format. This text is send in a HTTP POST body to the
SOAP service. Two headers must be sent in the request: Content-Type="text/XML" and
SOAPAction=paste(CUAHSINamespace, MethodName). For example if MethodName is GetSites and
the WaterML version is 1.1, then SOAPAction="http://www.cuahsi.org/his/1.1/ws/GetSites".
}
\description{
A helper function that makes a SOAP envelope to send to the
CUAHSI WaterOneFlow SOAP web service. It is internally used by the GetSites,
GetSiteInfo, GetVariables and GetValues functions.
}
\examples{
library(httr)
myEnvelope <- MakeSOAPEnvelope("http://www.cuahsi.org/his/1.1/ws/", "GetSitesObject")
SOAPAction <- "http://www.cuahsi.org/his/1.1/ws/GetSitesObject"
url <- "http://icewater.usu.edu/littlebearriver/cuahsi_1_1.asmx"
response <- POST(url, body = myEnvelope,
                 add_headers("Content-Type" = "text/xml", "SOAPAction" = SOAPAction),
                 verbose())
status.code <- http_status(response)$category
WaterML <- content(response)
WaterML
}
\keyword{WaterML}

