% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve2tune.R
\name{curve2tune}
\alias{curve2tune}
\title{Convert data from the depth to the time domain}
\usage{
curve2tune(
  data = NULL,
  tracked_cycle_curve = NULL,
  tracked_cycle_period = NULL,
  genplot = FALSE,
  keep_editable = FALSE
)
}
\arguments{
\item{data}{Data set (matrix with 2 columns 1st column depth 2nd column proxy value)
which was used as input for the \code{\link{analyze_wavelet}} function. \cr
That result was then used to tracked a cycle using the \code{\link{track_period_wavelet}} function}

\item{tracked_cycle_curve}{Tracking result of a cycle tracked using the
\code{\link{track_period_wavelet}} function \cr
Any input (matrix or data frame) in which the first column
is depth in meters and the second column is period in meters can be used.}

\item{tracked_cycle_period}{Period of the tracked curve (in kyr).}

\item{genplot}{If \code{genplot=TRUE} 3 plots stacked on top of each other will be plotted.
Plot 1: the original data set.
Plot 2: the depth time plot.
Plot 3: the data set in the time domain.}

\item{keep_editable}{Keep option to add extra features after plotting  \code{Default=FALSE}}
}
\value{
The output is a matrix with 2 columns.
The first column is time.
The second column sedimentation proxy value.

If \code{genplot=TRUE} then 3 plots stacked on top of each other will be plotted.
Plot 1: the original data set.
Plot 2: the depth time plot.
Plot 3: the data set in the time domain.
}
\description{
Converts a data set from the depth to the time domain
using a tracked curve/cycle to depth domain an assigning a duration (in kyr) set
tracked curve/cycle.
}
\examples{
\donttest{
#The example uses the magnetic susceptibility data set of Pas et al., (2018).
# perform the CWT
mag_wt <- analyze_wavelet(data = mag,
dj = 1/100,
lowerPeriod = 0.1,
upperPeriod = 254,
verbose = FALSE,
omega_nr = 10)

#Track the 405 kyr eccentricity cycle in a wavelet spectra

#mag_track <- track_period_wavelet(astro_cycle = 405,
#                                   wavelet=mag_wt,
#                                   n.levels = 100,
#                                   periodlab = "Period (meters)",
#                                   x_lab = "depth (meters)")

#Instead of tracking, the tracked solution data set mag_track_solution is used
mag_track <- mag_track_solution

mag_track_complete <- completed_series(
  wavelet = mag_wt,
  tracked_curve = mag_track,
  period_up = 1.2,
  period_down = 0.8,
  extrapolate = TRUE,
  genplot = FALSE
)

# smooth the tracking of the 405 kyr eccentricity cycle
mag_track_complete <- loess_auto(time_series = mag_track_complete,
genplot = FALSE, print_span = FALSE)

mag_track_time<- curve2tune(data=mag,
                           tracked_cycle_curve=mag_track_complete,
                           tracked_cycle_period=405,
                           genplot = FALSE,
                           keep_editable=FALSE)
}
}
\references{
Routines for astrochronologic testing, astronomical time scale construction, and
time series analysis <doi:10.1016/j.earscirev.2018.11.015>
}
\author{
Part of the code is based on the \link[astrochron]{sedrate2time}
function of the 'astrochron' R package
}
