% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xCircos.r
\name{xCircos}
\alias{xCircos}
\title{Function to visualise a network as a circos plot}
\usage{
xCircos(g, entity = c("SNP", "Gene"), top_num = 50, ideogram = T,
chr.exclude = "auto", entity.label.cex = 0.8, verbose = T,
RData.location =
"https://github.com/hfang-bristol/RDataCentre/blob/master/XGR/1.0.0")
}
\arguments{
\item{g}{an object of class "igraph". For example, it stores semantic
similarity results with nodes for genes/SNPs and edges for pair-wise
semantic similarity between them}

\item{entity}{the entity of similarity analysis for which results are
being plotted. It can be either "SNP" or "Gene"}

\item{top_num}{the top number of similarity edges to be plotted}

\item{ideogram}{logical to indicate whether chromosome banding is
plotted}

\item{chr.exclude}{a character vector of chromosomes to exclude from
the plot, e.g. c("chrX", "chrY"). By defautl, it is 'auto' meaning
those chromosomes without data will be excluded. If NULL, no chromosome
is excluded}

\item{entity.label.cex}{the font size of genes/SNPs labels. Default is
0.8}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}

\item{RData.location}{the characters to tell the location of built-in
RData files. See \code{\link{xRDataLoader}} for details}
}
\value{
a circos plot with edge weights between input snps/genes represented by
the colour of the links
}
\description{
\code{xCircos} is used to visualise a network as a circos plot. The
network must be a 'igraph' object.
}
\note{
none
}
\examples{
\dontrun{
# Load the library
library(XGR)
library(igraph)
library(RCircos)
library(GenomicRanges)

# provide genes and SNPs reported in AS GWAS studies
ImmunoBase <- xRDataLoader(RData.customised='ImmunoBase')

# 1) SNP-based similarity analysis using GWAS Catalog traits (mapped to EF)
## Get lead SNPs reported in AS GWAS
example.snps <- names(ImmunoBase$AS$variants)
SNP.g <- xSocialiserSNPs(example.snps, include.LD=NA)
# Circos plot of the EF-based SNP similarity network
#out.file <- "SNP_Circos.pdf"
#pdf(file=out.file, height=12, width=12, compress=TRUE)
xCircos(g=SNP.g, entity="SNP")
#dev.off()

# 2) Gene-based similarity analysis using Disease Ontology (DO)
## Get genes within 10kb away from AS GWAS lead SNPs
example.genes <- names(which(ImmunoBase$AS$genes_variants<=10000))
gene.g <- xSocialiserGenes(example.genes, ontology=c("DO")
# Circos plot of the DO-based gene similarity network
#out.file <- "Gene_Circos.pdf"
#pdf(file=out.file, height=12, width=12, compress=TRUE)
xCircos(g=gene.g, entity="Gene", chr.exclude="chrY")
#dev.off()
}
}
\seealso{
\code{\link{xSocialiserGenes}}, \code{\link{xSocialiserSNPs}}
}

