% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xAggregate.r
\name{xAggregate}
\alias{xAggregate}
\title{Function to aggregate data respecting number of features}
\usage{
xAggregate(data, bin = F, nbin = 10, scale.log = T, verbose = T)
}
\arguments{
\item{data}{a data frame. The aggregation is done across columns per
row. Each cell should contain positive values or NA; if infinite, it
will be replaced with the maximum finite value}

\item{bin}{logical to indicate whether the input data per column is
rank-transformed into the predefined number of discrete bins. By
default, it sets to false}

\item{nbin}{the number of discrete bins. By default, it sets to 10
(only works when bin is true)}

\item{scale.log}{logical to indicate whether the per-row sum is
log-scaled. By default, it sets to true}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}
}
\value{
a data frame with an appended column 'Aggregate'
}
\description{
\code{xAggregate} is supposed to aggregate data respecting number of
features. Per row, the aggregated is the sum of two items: the number
of features, and the sum of all but scaled into [0,0.9999999]. Also
supported is the rank-transformation of the input data per column,
binned into the predefined number of discrete bins.
}
\note{
None
}
\examples{
\dontrun{
# Load the library
library(XGR)

RData.location <- "http://galahad.well.ox.ac.uk/bigdata"
# HiC-gene pairs per cell types/states
g <- xRDataLoader(RData.customised='ig.PCHiC',
RData.location=RData.location)
df <- do.call(cbind, igraph::edge_attr(g))
# aggregate over cell types/states
data <- df
data[data<5] <- NA
res <- xAggregate(data)
}
}
\seealso{
\code{\link{xAggregate}}
}
