% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maize.muchow.model.r
\name{mm.A.fct}
\alias{mm.A.fct}
\title{Expanded leaf area function for Muchow et al. (1990) Maize model}
\usage{
mm.A.fct(LN, AM, LNM, a1 = -0.0344, a2 = 0.000731)
}
\arguments{
\item{LN}{: Leaf number}

\item{AM}{: area of the largest leaf (cm2)}

\item{LNM}{: leaf number having the largest area (-)}

\item{a1}{: coefficient of the statistical relation (default : -0.0344)}

\item{a2}{: coefficient of the statistical relation (default : 0.000731)}
}
\value{
vector of Expanded leaf area
}
\description{
Compute fully expanded area by leaf number (A, cm2)
}
\examples{
barplot(mm.A.fct(LN=1:20, AM=750, LNM=12),names.arg=1:20,
horiz=TRUE,xlab="leaf area (cm2)",ylab="leaf number")
}
\seealso{
\code{\link{maize.muchow.model}}, \code{\link{mm.LN.fct}}, \code{\link{mm.FAS.fct}}, \code{\link{maize.multisy}},
\code{\link{mm.HI.fct}},\code{\link{maize.muchow.graph}}
}
