% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_function.R
\name{canvas_function}
\alias{canvas_function}
\title{Draw Functions}
\usage{
canvas_function(color, background = "#fafafa", formula = NULL)
}
\arguments{
\item{color}{a string specifying the color used for the artwork.}

\item{background}{a character specifying the color used for the background.}

\item{formula}{optional, a named list with 'x''and 'y' as structured in the example. If \code{NULL} (default), chooses a function with random parameters.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function paints functions with random parameters on a canvas.
}
\examples{
\donttest{
set.seed(1)

# Simple example
canvas_function(color = "navyblue")

# Advanced example
formula <- list(
  x = quote(x_i^2 - sin(y_i^2)),
  y = quote(y_i^3 - cos(x_i^2))
)
canvas_function(color = "firebrick", formula = formula)
}

}
\references{
\url{https://github.com/cutterkom/generativeart}
}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
