% Generated by roxygen2 (4.0.2): do not edit by hand
\name{coint.test}
\alias{coint.test}
\title{Cointegration Test}
\usage{
coint.test(y, X, d = 0, nlag = NULL, output = TRUE)
}
\arguments{
\item{y}{the response}

\item{X}{the exogenous input variable of a numeric vector or a matrix.}

\item{d}{difference operator for both \code{y} and \code{X}. The default is 0.}

\item{nlag}{the lag order to calculate the test statistics. The default is \code{NULL}.}

\item{output}{a logical value indicating to print the results in R console.
The default is \code{TRUE}.}
}
\value{
A matrix for test results with three columns (\code{lag}, \code{EG}, \code{p.value})
 and three rows (\code{type1}, \code{type2}, \code{type3}).
 Each row is the test results (including lag parameter,
test statistic and p.value) for each type of linear regression models of residuals
\eqn{z[t]}. See \code{\link{adf.test}} for more details of three types of linear models.
}
\description{
Performs Engle-Granger(or EG) tests for the null hypothesis that two or more
time series, each of which is I(1), are not cointegrated.
}
\details{
To implement the original EG tests, one first has to fit the linear regression
\deqn{y[t] = \mu + B*X[t] + e[t],}
where \eqn{B} is the coefficient vector and \eqn{e[t]} is an error term.
With the fitted model, the residuals are obtained, i.e., \eqn{z[t] = y[t] - hat{y}[t]}
and a Augmented Dickey-Fuller test is utilized to examine whether the sequence of
residuals \eqn{z[t]} is white noise. The null hypothesis of non-cointegration
is equivalent to the null hypothesis that \eqn{z[t]} is white noise. See \code{\link{adf.test}}
for more details of Augmented Dickey-Fuller test, as well as the default \code{nlag}.
}
\examples{
X <- matrix(rnorm(200),100,2)
y <- 0.3*X[,1] + 1.2*X[,2] + rnorm(100)
# test for original y and X
coint.test(y,X)

# test for response = diff(y,differences = 1) and
# input = apply(X, diff, differences = 1)
coint.test(y,X,d = 1)
}
\author{
Debin Qiu
}
\references{
MacKinnon, J. G. (1991). Critical values for cointegration tests, Ch. 13 in Long-run
Economic Relationships: Readings in Cointegration, eds. R. F. Engle and C. W. J.
Granger, Oxford, Oxford University Press.
}
\seealso{
\code{\link{adf.test}}
}

