% Generated by roxygen2 (4.0.2): do not edit by hand
\name{estimate}
\alias{estimate}
\title{Estimate an ARIMA Model}
\usage{
estimate(x, p = 0, d = 0, q = 0, PDQ = c(0, 0, 0), S = NA,
  method = c("CSS-ML", "ML", "CSS"), intercept = TRUE, output = TRUE, ...)
}
\arguments{
\item{x}{a univariate time series.}

\item{p}{the AR order, can be a positive integer or a vector with several positive
integers. The default is \code{0}.}

\item{d}{the degree of differencing. The default is \code{0}.}

\item{q}{the MA order, can be a positive integer or a vector with several positive
integers. The default is \code{0}.}

\item{PDQ}{a vector with three non-negative integers for specification of the seasonal
part of the ARIMA model. The default is \code{c(0,0,0)}.}

\item{S}{the period of seasonal ARIMA model. The default is \code{NA}.}

\item{method}{fitting method. The default is \code{CSS-ML}.}

\item{intercept}{a logical value indicating to include the intercept in ARIMA model. The
default is \code{TRUE}.}

\item{output}{a logical value indicating to print the results in R console. The default is
\code{TRUE}.}

\item{...}{optional arguments to \code{\link{arima}} function.}
}
\value{
A list with class "\code{estimate}" and the same results as
\code{\link{arima}}. See \code{\link{arima}} for
more details.
}
\description{
Estimates an ARIMA model for a univariate time series, including a sparse
ARIMA model.
}
\details{
This function is similar to the ESTIMATE statement in ARIMA procedure of SAS,
except that it does not fit a transfer function model for a univariate time series. The
fitting method is inherited from \code{\link{arima}} in \code{stats} package. To be
specific, the pure ARIMA(p,q) is defined as
\deqn{X[t] = \mu + \phi[1]*X[t-1] + ... + \phi[p]*X[p] +
             e[t] - \theta[1]*e[t-1] - ... - \theta[q]*e[t-q].}
The \code{p} and \code{q} can be a vector for fitting a sparse ARIMA model. For example,
\code{p = c(1,3),q = c(1,3)} means the ARMA((1,3),(1,3)) model defined as
\deqn{X[t] = \mu + \phi[1]*X[t-1] + \phi[3]*X[t-3] + e[t]
- \theta[1]*e[t-1] - \theta[3]*e[t-3].} The \code{PDQ} controls the
order of seasonal ARIMA model, i.e., ARIMA(p,d,q)x(P,D,Q)(S), where S is the seasonal
period. Note that the difference operators \code{d} and D = \code{PDQ}[2] are different.
The \code{d} is equivalent to \code{diff(x,differences = d)} and D is
\code{diff(x,lag = D,differences = S)}, where the default seasonal period is
\code{S = frequency(x)}.

The residual diagnostics plots will be drawn.
}
\note{
Missing values are removed before the estimate. Sparse seasonal
ARIMA(p,d,q)x(P,D,Q)(S) model is not allowed.
}
\examples{
estimate(lh, p = 1) # AR(1) process
estimate(lh, p = 1, q = 1) # ARMA(1,1) process
estimate(lh, p = c(1,3)) # sparse AR((1,3)) process

# seasonal ARIMA(0,1,1)x(0,1,1)(12) model
estimate(USAccDeaths, p = 1, d = 1, PDQ = c(0,1,1))
}
\author{
Debin Qiu
}
\references{
Brockwell, P. J. and Davis, R. A. (1996). Introduction to Time Series and Forecasting.
Springer, New York. Sections 3.3 and 8.3.
}
\seealso{
\code{\link{arima}},  \code{\link{identify}},  \code{\link{forecast}}
}

