% Generated by roxygen2 (4.0.2): do not edit by hand
\name{expsmooth}
\alias{expsmooth}
\title{Simple Exponential Smoothing}
\usage{
expsmooth(x, trend = 1, alpha = 0.2, beta = 0.10557, gamma = 0.07168,
  lead = 0, plot = TRUE)
}
\arguments{
\item{x}{a numeric vector or univariate time series.}

\item{trend}{the type of trend. See details.}

\item{alpha}{the smoothing parameter for constant component. The default is \code{0.2}.}

\item{beta}{the smoothing parameter for linear component. The default is \code{0.10557}.}

\item{gamma}{the smoothing parameter for quadratic component. The default is \code{0.07168}.}

\item{lead}{the number of steps ahead for which prediction is required.
The default is \code{0}.}

\item{plot}{a logical value indicating to print the plot of original data v.s smoothed
data. The default is \code{TRUE}.}
}
\value{
A list with class \code{"es"} containing the following components:
\item{estimate}{the smoothed values.}
\item{pred}{the predicted values when \code{lead} > 0.}
\item{accurate}{the accurate measurements.}
}
\description{
Performs a simple exponential smoothing for univariate time series
with no trend or seasonal pattern.
}
\details{
Simple exponential smoothing is a weighted average between the most recent
observation and the most recent forecasting, with weights \eqn{\alpha} and
\eqn{1 - \alpha}, respectively. To be precise, the smoothing equation of single exponential
smoothing (constant model, \code{trend = 1}) is given by
\deqn{level[t] = \alpha *x[t] + (1 - \alpha)*level[t-1],}
and the forecasting equation is
\deqn{hat{x}[t+1|t] = level[t],}
for \eqn{t = 1,...,n}.
The initial value \eqn{level[0] = x[1]}. For example, \eqn{hat{x}[1|0] = level[0]},
\eqn{hat{x}[2|1] = level[1]},..., etc.

Let \eqn{x1[t]} be the smoothed values of single exponential smoothing. The double
exponential smoothing (\code{trend = 2}, a linear model) is to apply a single
exponential smoothing again to the smoothed sequence \eqn{x1[t]}, with a new smoothing
parameter \code{beta}. Similarly, we denote the smoothed values of double
exponential smoothing to be \eqn{x2[t]}. The triple exponential smoothing
(\code{trend = 3}, a quadratic model) is to apply the single exponential smoothing
to the smoothed sequence \eqn{x2[t]} with a new smoothing parameter \code{gamma}. The
default smoothing parameters (weights) \code{alpha}, \code{beta}, \code{gamma} are
taken from the equation \code{1 - 0.8^{1/trend}} respectively, which is similar
to the FORECAST procedure in SAS.
}
\note{
Missing values are removed before the analysis.
}
\examples{
x <- rnorm(100)
es <- expsmooth(x) # trend = 1: a constant model
plot(x,type = "l")
lines(es$estimate,col = 2)
expsmooth(x,trend = 2) # trend = 2: a linear model
expsmooth(x,trend = 3) # trend = 3: a quadratic model
}
\author{
Debin Qiu
}
\seealso{
\code{\link{Winters}}, \code{\link{Holt}}, \code{\link{MA}}
}

