% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ex2.dag.data}
\alias{ex2.dag.data}
\title{Synthetic validation data set for use with abn library examples}
\format{
A data frame, binary variables are factors.
The relevant formulas are given below (note these do not give parameter
estimates just the form of the relationships, e.g. logit()=1
means a logit link function and comprises of only an intercept term).
\describe{
\item{b1}{binary,logit()=1+g1+b2+b3+p3+b4+g4+b5}
\item{g1}{gaussian,identity()=1}
\item{p1}{poisson,log()=1+g6}
\item{b2}{binary,logit()=1+p3+b4+p6}
\item{g2}{gaussian,identify()=1+b2}
\item{p2}{poisson,log()=1+b2}
\item{b3}{binary,logit()=1+g1+g2+p2+g3+p3+g4}
\item{g3}{gaussian,identify()=1+g1+p3+b4}
\item{p3}{poisson,log()=1}
\item{b4}{binary,logit()=1+g1+p3+p5}
\item{g4}{gaussian,identify()=1+b4;}
\item{p4}{poisson,log()=1+g1+b2+g2+b5}
\item{b5}{binary,logit()=1+b2+g2+b3+p3+g4}
\item{g5}{gaussian,identify()=1}
\item{p5}{poisson,log()=1+g1+g5+b6+g6}
\item{b6}{binary,logit()=1}
\item{g6}{gaussian,identify()=1}
\item{p6}{poisson,log()=1+g5}
}
}
\usage{
ex2.dag.data
}
\description{
10000 observations simulated from a DAG with 18 variables three sets each from Poisson, Bernoulli and Gaussian distributions.
}
\examples{
## The true underlying stochastic model has DAG - this data is a single realisation.
ex2.true.dag <- matrix(data = c(
  0,1,0,1,0,0,1,0,1,1,1,0,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,
  0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,
  0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,0,0,1,1,0,1,1,0,1,0,0,0,0,0,0,0,
  0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,
  0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
  0,1,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,
  0,0,0,1,1,0,1,0,1,0,1,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0
), ncol = 18, byrow = TRUE)

colnames(ex2.true.dag) <- rownames(ex2.true.dag) <- c("b1","g1","p1","b2",
                                                      "g2","p2","b3","g3",
                                                      "p3","b4","g4","p4",
                                                      "b5","g5","p5","b6",
                                                      "g6","p6")
}
\keyword{datasets}
\keyword{internal}
