% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cost_to_closest.R
\name{cost_to_closest}
\alias{cost_to_closest}
\title{Minimum travel cost to closest N number of opportunities}
\usage{
cost_to_closest(
  travel_matrix,
  land_use_data,
  opportunity,
  travel_cost,
  n = 1,
  group_by = character(0),
  active = TRUE,
  fill_missing_ids = TRUE
)
}
\arguments{
\item{travel_matrix}{A data frame. The travel matrix describing the costs
(i.e. travel time, distance, monetary cost, etc.) between the origins and
destinations in the study area. Must contain the columns \code{from_id}, \code{to_id}
and any others specified in \code{travel_cost_col}.}

\item{land_use_data}{A data frame. The distribution of opportunities within
the study area cells. Must contain the columns \code{id} and any others
specified in \code{opportunity_col}.}

\item{opportunity}{A string. The name of the column in \code{land_use_data}
with the number of opportunities/resources/services to be considered when
calculating accessibility levels.}

\item{travel_cost}{A string. The name of the column in \code{travel_matrix}
with the travel cost between origins and destinations. Defaults to
\code{"travel_time"}.}

\item{n}{A \code{numeric}. A number indicating the minimum number of opportunities
that should be considered. Defaults to 1.}

\item{group_by}{A \code{character} vector. When not \code{character(0)} (the default),
indicates the \code{travel_matrix} columns that should be used to group the
accessibility estimates by. For example, if \code{travel_matrix} includes a
departure time column, that specifies the departure time of each entry in
the data frame, passing \code{"departure_time"} to this parameter results in
accessibility estimates grouped by origin and by departure time.}

\item{active}{A logical. Whether to calculate active accessibility (the
of opportunities that can be reached from a given origin, the default) or
passive accessibility (by how many people each destination can be reached).}

\item{fill_missing_ids}{A \code{logical}. Calculating minimum trave cost to
closest N number of opportunities may result in missing ids in the output
if they cannot reach the specified amount of opportunities across all
destinations they can reach. For example, estimating the minimum travel
time that an origin that can only reach 4 opportunities takes to reach 5
opportunities resulting in such origin not being included in the output.
When \code{TRUE} (the default), the function identifies which ids would be left
out from the output and fill their respective minimum travel costs with
\code{Inf}, which incurs in a performance penalty.}
}
\value{
A data frame containing the accessibility estimates for each
origin/destination (depending if \code{active} is \code{TRUE} or \code{FALSE}) in the
travel matrix.
}
\description{
Calculates the minimum travel cost to the closest N number of opportunities.

This function is generic over any kind of numeric travel cost,
such as distance, time and money.
}
\examples{
data_dir <- system.file("extdata", package = "accessibility")
travel_matrix <- readRDS(file.path(data_dir, "travel_matrix.rds"))
land_use_data <- readRDS(file.path(data_dir, "land_use_data.rds"))

df <- cost_to_closest(
  travel_matrix,
  land_use_data,
  n = 1,
  opportunity = "schools",
  travel_cost = "travel_time"
)
head(df)

df <- cost_to_closest(
  travel_matrix,
  land_use_data,
  n = 2,
  opportunity = "schools",
  travel_cost = "travel_time"
)
head(df)

}
