% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clear.R
\name{ada_clear_port}
\alias{ada_clear_port}
\alias{ada_clear_hash}
\alias{ada_clear_search}
\title{Clear a specific component of URL}
\usage{
ada_clear_port(url, decode = TRUE)

ada_clear_hash(url, decode = TRUE)

ada_clear_search(url, decode = TRUE)
}
\arguments{
\item{url}{character. one or more URL to be parsed}

\item{decode}{logical. Whether to decode the output (see \code{\link[utils:URLencode]{utils::URLdecode()}}), default to \code{TRUE}}
}
\value{
character, \code{NA} if not a valid URL
}
\description{
These functions clears a specific component of URL.
}
\examples{
url <- "https://user_1:password_1@example.org:8080/dir/../api?q=1#frag"
ada_clear_port(url)
ada_clear_hash(url)
ada_clear_search(url)
}
