% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_cv.R
\name{adapt_cv}
\alias{adapt_cv}
\title{fit an adaptive lasso with adaptive weights derived from lasso-cv}
\usage{
adapt_cv(
  x,
  y,
  gamma = 1,
  nfolds = 5,
  foldid = NULL,
  type_cv = "proper",
  betaPos = TRUE,
  ...
)
}
\arguments{
\item{x}{Input matrix, of dimension nobs x nvars. Each row is an observation
vector. Can be in sparse matrix format (inherit from class
\code{"sparseMatrix"} as in package \code{Matrix}).}

\item{y}{Binary response variable, numeric.}

\item{gamma}{Tunning parameter to defined the penalty weights. See details below.
Default is set to 1.}

\item{nfolds}{Number of folds - default is 5. Although \code{nfolds} can be
as large as the sample size (leave-one-out CV), it is not recommended for
large datasets. Smallest value allowable is \code{nfolds=3}.}

\item{foldid}{An optional vector of values between 1 and \code{nfolds}
identifying what fold each observation is in. If supplied, \code{nfolds} can
be missing.}

\item{type_cv}{Character, indicates which implementation of cross-validation is performed for the adaptive lasso:  a "naive" one,
where adaptive weights obtained on the full data are used, and a "proper" one, where adaptive weights are calculated for each training sets.
Could be either "naive" or "proper".
Default is "proper".}

\item{betaPos}{Should the covariates selected by the procedure be
positively associated with the outcome ? Default is \code{TRUE}.}

\item{\dots}{Other arguments that can be passed to \code{glmnet}  from package \code{glmnet} other than \code{nfolds}, \code{foldid},
\code{penalty.factor}, \code{standardize}, \code{intercept}  and \code{family}.}
}
\value{
An object with S3 class \code{"adaptive"}.
\item{aws}{Numeric vector of penalty weights derived from cross-validation.
Length equal to nvars.}
\item{criterion}{Character, indicates which criterion is used with the
adaptive lasso for variable selection. For \code{adapt_cv} function, \code{criterion}
is "cv".}
\item{beta}{Numeric vector of regression coefficients in the adaptive lasso.
If \code{criterion} = "cv" the regression coefficients are PENALIZED, if
\code{criterion} = "bic" the regression coefficients are UNPENALIZED.
Length equal to nvars. Could be NA if adaptive weights are all equal to infinity.}
\item{selected_variables}{Character vector, names of variable(s) selected
with this adaptive approach.
If \code{betaPos = TRUE}, this set is the covariates with a positive regression
coefficient in \code{beta}.
Else this set is the covariates with a non null regression coefficient in \code{beta}.
Covariates are ordering according to magnitude of their regression
coefficients absolute value in the adaptive lasso.}
}
\description{
Fit a first lasso regression with cross-validation to determine adaptive weights.
Run a cross-validation to determine an optimal lambda.
Two options for implementing cross-validation for the adaptive lasso are possible through the \code{type_cv} parameter (see bellow).
Can deal with very large sparse data matrices.
Intended for binary reponse only (option \code{family = "binomial"} is forced).
The cross-validation criterion used is deviance.
Depends on the \code{cv.glmnet} function from the package \code{glmnet}.
}
\details{
The adaptive weight for a given covariate i is defined by
\deqn{w_i = 1/|\beta^{CV}_i|^\gamma} where
\eqn{\beta^{CV}_i} is the PENALIZED regression coefficient associated
to covariate \eqn{i} obtained with cross-validation.
}
\examples{

set.seed(15)
drugs <- matrix(rbinom(100*20, 1, 0.2), nrow = 100, ncol = 20)
colnames(drugs) <- paste0("drugs",1:ncol(drugs))
ae <- rbinom(100, 1, 0.3)
acv <- adapt_cv(x = drugs, y = ae, nfolds = 5)


}
\author{
Emeline Courtois \cr Maintainer: Emeline Courtois
\email{emeline.courtois@inserm.fr}
}
