% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adass_functions.R
\name{simulate_data}
\alias{simulate_data}
\title{Simulate data through the function-on-function linear regression model}
\usage{
simulate_data(scenario, n_obs = 3000)
}
\arguments{
\item{scenario}{A  character strings indicating the scenario considered. It could be "Scenario HAT", "Scenario DAMP", or "Scenario RCHANGE".}

\item{n_obs}{Number of observations.}
}
\value{
A list containing the following arguments:

\code{X}: Covariate matrix, where  the rows  correspond to argument values and columns to replications.

\code{Y}: Response matrix, where  the rows  correspond to argument values and columns to replications.

\code{X_fd}: Coavariate functions.

\code{Y_fd}: Response functions.

\code{Beta_vero_fd}: The true coefficient function.
}
\description{
Generate synthetic data as in the simulation study of Centofanti et al. (2020).
}
\examples{
library(adass)
data<-simulate_data("Scenario HAT",n_obs=100)
}
\references{


Centofanti, F., Lepore, A., Menafoglio, A., Palumbo, B., Vantini, S. (2020).
Adaptive Smoothing Spline Estimator for the Function-on-Function Linear Regression Model.
\emph{arXiv preprint arXiv:2011.12036}.
}
