% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directory.R
\name{list_adf_entries}
\alias{list_adf_entries}
\alias{list_adf_entries.adf_device}
\alias{list_adf_entries.virtual_path}
\alias{list_adf_entries.adf_device.character}
\alias{list_adf_entries.adf_device.virtual_path}
\title{List entries in a directory of a virtual ADF device}
\usage{
list_adf_entries(x, path, recursive = FALSE, nested = FALSE, ...)

\method{list_adf_entries}{adf_device}(x, path, recursive = FALSE, nested = FALSE, ...)

\method{list_adf_entries}{virtual_path}(x, path, recursive = FALSE, nested = FALSE, ...)

\method{list_adf_entries.adf_device}{character}(x, path, recursive = FALSE, nested = FALSE, ...)

\method{list_adf_entries.adf_device}{virtual_path}(x, path, recursive = FALSE, ...)
}
\arguments{
\item{x}{Either an \code{adf_device} class object, in which case the \code{virtual_path}
argument needs to be specified; or, a \code{virtual_path} class object.}

\item{path}{The virtual path for which you wish to obtain a list
of entries (see also \code{vignette("virtual_paths")}). When missing,
entries for the current directory (\code{\link[=adf_directory]{adf_directory()}}) are returned, wen
\code{x} is an \code{adf_device} class object. If \code{x} is a \code{virtual_path} class
object, content of the path defined in that object is listed}

\item{recursive}{A \code{logical} value. When set to \code{TRUE}, the function is
called recursively for all subdirectories in \code{path}.}

\item{nested}{A \code{logical} value. When set to The directory tree is returned
as a nested list.}

\item{...}{Ignored}
}
\value{
A vector of \code{virtual_path} class objects, or a nested \code{list} in
case \code{nested} is \code{TRUE}.
}
\description{
Get an overview of all entries (files and directories) in a specific
directory.
}
\examples{
## First setup a connection to a virtual device
adz_file <- system.file("example.adz", package = "adfExplorer")
my_device <- connect_adf(adz_file)

## List all entries in the disk's root:
list_adf_entries(my_device)
## List all entries on the disk:
list_adf_entries(my_device, recursive = TRUE)

close(my_device)
}
\author{
Pepijn de Vries
}
