% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_extreme_flag.R
\name{derive_var_worst_flag}
\alias{derive_var_worst_flag}
\title{Adds a Variable Flagging the Maximal / Minimal Value Within a Group of Observations}
\usage{
derive_var_worst_flag(
  dataset,
  by_vars,
  order,
  new_var,
  param_var,
  analysis_var,
  worst_high,
  worst_low,
  check_type = "warning"
)
}
\arguments{
\item{dataset}{Input dataset.
Variables specified by \code{by_vars}, \code{order}, \code{param_var}, and \code{analysis_var} are expected.}

\item{by_vars}{Grouping variables

Permitted Values: list of variables}

\item{order}{Sort order.
Used to determine maximal / minimal observation if they are not unique,
see Details section for more information.}

\item{new_var}{Variable to add to the \code{dataset}.
It is set \code{"Y"} for the maximal / minimal observation of each group,
see Details section for more information.}

\item{param_var}{Variable with the parameter values for which the maximal / minimal
value is calculated.}

\item{analysis_var}{Variable with the measurement values for which the maximal / minimal
value is calculated.}

\item{worst_high}{Character with \code{param_var} values specifying the parameters
referring to "high".
Use \code{character(0)} if not required.}

\item{worst_low}{Character with \code{param_var} values specifying the parameters
referring to "low".
Use \code{character(0)} if not required.}

\item{check_type}{Check uniqueness?

If \code{"warning"} or \code{"error"} is specified, the specified message is issued
if the observations of the input dataset are not unique with respect to the
by variables and the order.

Default: \code{"warning"}

Permitted Values: \code{"none"}, \code{"warning"}, \code{"error"}}
}
\value{
The input dataset with the new flag variable added.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function is \emph{deprecated}. Please use \code{slice_derivation()} / \code{derive_var_extreme_flag()}
to derive extreme flags and adjust the \code{order} argument.
}
\details{
For each group with respect to the variables specified by the \code{by_vars} parameter,
the maximal / minimal observation of \code{analysis_var}
is labeled in the \code{new_var} column as \code{"Y"},
if its \code{param_var} is in \code{worst_high} / \code{worst_low}.
Otherwise, it is assigned \code{NA}.
If there is more than one such maximal / minimal observation,
the first one with respect to the order specified by the \code{order} parameter is flagged. The
direction of "worst" depends on the definition of worst for a specified parameters in the
arguments \code{worst_high} / \code{worst_low}, i.e. for some parameters the highest value is the worst
and for others the worst is the lowest value.
}
\seealso{
\code{\link[=derive_var_extreme_flag]{derive_var_extreme_flag()}}

Other deprecated: 
\code{\link{derive_derived_param}()},
\code{\link{derive_param_first_event}()},
\code{\link{derive_var_agegr_fda}()},
\code{\link{derive_var_confirmation_flag}()},
\code{\link{derive_var_disposition_status}()},
\code{\link{derive_vars_disposition_reason}()},
\code{\link{derive_vars_merged_dtm}()},
\code{\link{derive_vars_merged_dt}()},
\code{\link{filter_confirmation}()},
\code{\link{format_eoxxstt_default}()},
\code{\link{format_reason_default}()},
\code{\link{vars}()}
}
\concept{deprecated}
\keyword{deprecated}
