% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_duration.R
\name{derive_vars_duration}
\alias{derive_vars_duration}
\title{Derive Duration}
\usage{
derive_vars_duration(
  dataset,
  new_var,
  new_var_unit = NULL,
  start_date,
  end_date,
  in_unit = "days",
  out_unit = "days",
  floor_in = TRUE,
  add_one = TRUE,
  trunc_out = FALSE
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{start_date} and the \code{end_date} parameter are
expected.}

\item{new_var}{Name of variable to create}

\item{new_var_unit}{Name of the unit variable If the parameter is not
specified, no variable for the unit is created.}

\item{start_date}{The start date

A date or date-time variable is expected. This variable must be present in
specified input dataset.

Refer to \code{derive_vars_dt()} to impute and derive a date from a date
character vector to a date object.}

\item{end_date}{The end date

A date or date-time variable is expected. This variable must be present in
specified input dataset.

Refer to \code{derive_vars_dt()} to impute and derive a date from a date
character vector to a date object.}

\item{in_unit}{Input unit

See floor_in and add_one parameter for details.

Default: 'days'

Permitted Values: 'years', 'months', 'days', 'hours', 'minutes', 'min',
'seconds', 'sec'}

\item{out_unit}{Output unit

The duration is derived in the specified unit

Default: 'days'

Permitted Values: 'years', 'months', 'days', 'hours', 'minutes', 'min',
'seconds', 'sec'}

\item{floor_in}{Round down input dates?

The input dates are round down with respect to the input unit, e.g., if the
input unit is 'days', the time of the input dates is ignored.

Default: `TRUE``

Permitted Values: \code{TRUE}, \code{FALSE}}

\item{add_one}{Add one input unit?

If the duration is non-negative, one input unit is added. I.e., the
duration can not be zero.

Default: \code{TRUE} Permitted Values: \code{TRUE}, \code{FALSE}}

\item{trunc_out}{Return integer part

The fractional part of the duration (in output unit) is removed, i.e., the
integer part is returned.

Default: \code{FALSE}

Permitted Values: \code{TRUE}, \code{FALSE}}
}
\value{
The input dataset with the duration and unit variable added
}
\description{
Derives duration between two dates, specified by the variables present in
input dataset e.g., duration of adverse events, relative day, age, ...
}
\details{
The duration is derived as time from start to end date in the
specified output unit. If the end date is before the start date, the duration
is negative. The start and end date variable must be present in the specified
input dataset.
}
\examples{
library(lubridate)
library(tibble)

# Derive age in years
data <- tribble(
  ~USUBJID, ~BRTHDT, ~RANDDT,
  "P01", ymd("1984-09-06"), ymd("2020-02-24"),
  "P02", ymd("1985-01-01"), NA,
  "P03", NA, ymd("2021-03-10"),
  "P04", NA, NA
)

derive_vars_duration(data,
  new_var = AAGE,
  new_var_unit = AAGEU,
  start_date = BRTHDT,
  end_date = RANDDT,
  out_unit = "years",
  add_one = FALSE,
  trunc_out = TRUE
)

# Derive adverse event duration in days
data <- tribble(
  ~USUBJID, ~ASTDT, ~AENDT,
  "P01", ymd("2021-03-05"), ymd("2021-03-02"),
  "P02", ymd("2019-09-18"), ymd("2019-09-18"),
  "P03", ymd("1985-01-01"), NA,
  "P04", NA, NA
)

derive_vars_duration(data,
  new_var = ADURN,
  new_var_unit = ADURU,
  start_date = ASTDT,
  end_date = AENDT,
  out_unit = "days"
)

# Derive adverse event duration in minutes
data <- tribble(
  ~USUBJID, ~ADTM, ~TRTSDTM,
  "P01", ymd_hms("2019-08-09T04:30:56"), ymd_hms("2019-08-09T05:00:00"),
  "P02", ymd_hms("2019-11-11T10:30:00"), ymd_hms("2019-11-11T11:30:00"),
  "P03", ymd_hms("2019-11-11T00:00:00"), ymd_hms("2019-11-11T04:00:00"),
  "P04", NA, ymd_hms("2019-11-11T12:34:56"),
)

derive_vars_duration(data,
  new_var = ADURN,
  new_var_unit = ADURU,
  start_date = ADTM,
  end_date = TRTSDTM,
  in_unit = "minutes",
  out_unit = "minutes",
  add_one = FALSE
)

# Derive adverse event start time since last dose in hours
data <- tribble(
  ~USUBJID, ~ASTDTM, ~LDOSEDTM,
  "P01", ymd_hms("2019-08-09T04:30:56"), ymd_hms("2019-08-08T10:05:00"),
  "P02", ymd_hms("2019-11-11T23:59:59"), ymd_hms("2019-10-11T11:37:00"),
  "P03", ymd_hms("2019-11-11T00:00:00"), ymd_hms("2019-11-10T23:59:59"),
  "P04", ymd_hms("2019-11-11T12:34:56"), NA,
  "P05", NA, ymd_hms("2019-09-28T12:34:56")
)
derive_vars_duration(
  data,
  new_var = LDRELTM,
  new_var_unit = LDRELTMU,
  start_date = LDOSEDTM,
  end_date = ASTDTM,
  in_unit = "hours",
  out_unit = "hours",
  add_one = FALSE
)
}
\seealso{
\code{\link[=compute_duration]{compute_duration()}}

Date/Time Derivation Functions that returns variable appended to dataset: 
\code{\link{derive_var_trtdurd}()},
\code{\link{derive_vars_dtm_to_dt}()},
\code{\link{derive_vars_dtm_to_tm}()},
\code{\link{derive_vars_dtm}()},
\code{\link{derive_vars_dt}()},
\code{\link{derive_vars_dy}()}
}
\concept{der_date_time}
\keyword{der_date_time}
\keyword{der_gen}
