% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_query.R
\name{derive_vars_query}
\alias{derive_vars_query}
\title{Derive Query Variables}
\usage{
derive_vars_query(dataset, dataset_queries)
}
\arguments{
\item{dataset}{Input dataset.}

\item{dataset_queries}{A dataset containing required columns \code{VAR_PREFIX},
\code{QUERY_NAME}, \code{TERM_LEVEL}, \code{TERM_NAME}, \code{TERM_ID}, and optional columns
\code{QUERY_ID}, \code{QUERY_SCOPE}, \code{QUERY_SCOPE_NUM}.

The content of the dataset will be verified by \code{\link[=assert_valid_queries]{assert_valid_queries()}}.

\code{create_query_data()} can be used to create the dataset.}
}
\value{
The input dataset with query variables derived.
}
\description{
Derive Query Variables
}
\details{
This function can be used to derive CDISC variables such as
\code{SMQzzNAM}, \code{SMQzzCD}, \code{SMQzzSC}, \code{SMQzzSCN}, and \code{CQzzNAM} in ADAE and
ADMH, and variables such as \code{SDGzzNAM}, \code{SDGzzCD}, and \code{SDGzzSC} in ADCM.
An example usage of this function can be found in the
\href{../articles/occds.html}{OCCDS vignette}.

A query dataset is expected as an input to this function. See the
\href{../articles/queries_dataset.html}{Queries Dataset Documentation vignette}
for descriptions, or call \code{data("queries")} for an example of a query dataset.

For each unique element in \code{VAR_PREFIX}, the corresponding "NAM"
variable will be created. For each unique \code{VAR_PREFIX}, if \code{QUERY_ID} is
not "" or NA, then the corresponding "CD" variable is created; similarly,
if \code{QUERY_SCOPE} is not "" or NA, then the corresponding "SC" variable will
be created; if \code{QUERY_SCOPE_NUM} is not "" or NA, then the corresponding
"SCN" variable will be created.

For each record in \code{dataset}, the "NAM" variable takes the value of
\code{QUERY_NAME} if the value of \code{TERM_NAME} or \code{TERM_ID} in \code{dataset_queries} matches
the value of the respective TERM_LEVEL in \code{dataset}.
Note that \code{TERM_NAME} in \code{dataset_queries} dataset may be NA only when \code{TERM_ID}
is non-NA and vice versa.
The "CD", "SC", and "SCN" variables are derived accordingly based on
\code{QUERY_ID}, \code{QUERY_SCOPE}, and \code{QUERY_SCOPE_NUM} respectively,
whenever not missing.
}
\examples{
library(tibble)
data("queries")
adae <- tribble(
  ~USUBJID, ~ASTDTM, ~AETERM, ~AESEQ, ~AEDECOD, ~AELLT, ~AELLTCD,
  "01", "2020-06-02 23:59:59", "ALANINE AMINOTRANSFERASE ABNORMAL",
  3, "Alanine aminotransferase abnormal", NA_character_, NA_integer_,
  "02", "2020-06-05 23:59:59", "BASEDOW'S DISEASE",
  5, "Basedow's disease", NA_character_, 1L,
  "03", "2020-06-07 23:59:59", "SOME TERM",
  2, "Some query", "Some term", NA_integer_,
  "05", "2020-06-09 23:59:59", "ALVEOLAR PROTEINOSIS",
  7, "Alveolar proteinosis", NA_character_, NA_integer_
)
derive_vars_query(adae, queries)
}
\seealso{
\code{\link[=create_query_data]{create_query_data()}} \code{\link[=assert_valid_queries]{assert_valid_queries()}}

OCCDS Functions: 
\code{\link{derive_var_trtemfl}()},
\code{\link{derive_vars_atc}()},
\code{\link{get_terms_from_db}()}
}
\concept{der_occds}
\keyword{der_occds}
