% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_disposition_dt.R
\name{derive_disposition_dt}
\alias{derive_disposition_dt}
\title{Derive a Disposition Date}
\usage{
derive_disposition_dt(
  dataset,
  dataset_ds,
  new_var,
  dtc,
  filter_ds,
  date_imputation = NULL,
  subject_keys = vars(STUDYID, USUBJID)
)
}
\arguments{
\item{dataset}{Input dataset}

\item{dataset_ds}{Datasets containing the disposition information (e.g.: ds)

It must contain:
\itemize{
\item \code{STUDYID}, \code{USUBJID},
\item The variable(s) specified in the \code{dtc}
\item The variables used in \code{filter_ds}.
}}

\item{new_var}{Name of the disposition date variable

a variable name is expected}

\item{dtc}{The character date used to derive/impute the disposition date

A character date is expected in a format like yyyy-mm-dd or yyyy-mm-ddThh:mm:ss.
If the year part is not recorded (missing date), no imputation is performed.}

\item{filter_ds}{Filter condition for the disposition data.

Filter used to select the relevant disposition data.
It is expected that the filter restricts \code{dataset_ds} such that there is at most
one observation per patient. An error is issued otherwise.

Permitted Values: logical expression.}

\item{date_imputation}{The value to impute the day/month when a datepart is missing.

If \code{NULL}: no date imputation is performed and partial dates are returned as missing.

Otherwise, a character value is expected, either as a
\itemize{
\item format with day and month specified as 'mm-dd': e.g. '06-15' for the 15th
of June
\item or as a keyword: 'FIRST', 'MID', 'LAST' to impute to the first/mid/last day/month.
}

Default is \code{NULL}}

\item{subject_keys}{Variables to uniquely identify a subject

A list of quosures where the expressions are symbols as returned by
\code{vars()} is expected.}
}
\value{
the input dataset with the disposition date (\code{new_var}) added
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\emph{Deprecated}, please use \code{derive_var_disposition_dt()} instead.

Derive a disposition status date from the the relevant records in the disposition domain.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(admiral.test)
data("dm")
data("ds")

dm \%>\%
  derive_disposition_dt(
    dataset_ds = ds,
    new_var = FRVDT,
    dtc = DSSTDTC,
    filter_ds = DSCAT == "OTHER EVENT" & DSDECOD == "FINAL RETRIEVAL VISIT"
  ) \%>\%
  select(STUDYID, USUBJID, FRVDT)
}
\author{
Samia Kabi
}
\keyword{adsl}
\keyword{timing}
