% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_one_to_one}
\alias{assert_one_to_one}
\title{Is There a One to One Mapping between Variables?}
\usage{
assert_one_to_one(dataset, vars1, vars2)
}
\arguments{
\item{dataset}{Dataset to be checked

The variables specified for \code{vars1} and \code{vars2} are expected.}

\item{vars1}{First list of variables}

\item{vars2}{Second list of variables}
}
\value{
An error if the condition is not meet. The input otherwise.
}
\description{
Checks if there is a one to one mapping between two lists of variables.
}
\examples{
data(admiral_adsl)
try(
  assert_one_to_one(admiral_adsl, vars(SEX), vars(RACE))
)
}
\author{
Stefan Bundfuss
}
\keyword{assertion}
