\name{bar.err}
\alias{bar.err}
%- bar.err.
\title{ Plotting the standard error or standard deviance of a multiple comparison of means  }
\description{
 It plots bars of the averages of treatments and standard error or standard 
 deviance. It uses the objects generated by a procedure of comparison like LSD,
 HSD, Kruskal and Waller-Duncan. 
 }
\usage{
bar.err(x,variation=c("std","SE","rank"),horiz=FALSE, bar=TRUE,...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{ object means of the comparisons the LSD.test, HSD.test,...,etc }
  \item{variation}{ std=Standard deviation, SE=standard error or rank=Max.-Min.}
  \item{horiz}{ Horizontal or vertical bars }
  \item{bar}{paint bar}
  \item{\dots}{ Parameters of the function barplot()}
}
\details{
  x: data frame formed by 5 columns: name of the bars, height, level
  out: LSD.test, HSD, waller.test, scheffe.test, duncan.test, SNK.test, friedman, kruskal, waerden.test 
  x: out$means
}
\value{
  \item{x}{ object  }
  \item{variation}{ character std, SE or rank }
  \item{horiz}{ TRUE or FALSE }
  \item{bar}{ TRUE or FALSE }
  \item{\dots}{ Parameters of the function barplot()}
}

\author{ Felipe de Mendiburu }

\seealso{\code{\link{LSD.test}}, \code{\link{HSD.test}}, \code{\link{waller.test}}, 
\code{\link{kruskal}}, \code{\link{bar.group}} }

\examples{
library(agricolae)
data(sweetpotato)
model<-aov(yield~virus,data=sweetpotato)
out <- waller.test(model,"virus",
main="Yield of sweetpotato\ndealt with different virus")
par(mfrow=c(1,2),cex=1)
bar.err(out$means,variation="std",ylim=c(0,45),bar=FALSE,col=0)
abline(h=0)
# horiz = TRUE
bar.err(out$means,variation="std",horiz=TRUE,xlim=c(0,45),bar=FALSE,col=0)
# std = FALSE (default) is standard error 
#startgraph
par(mfrow=c(2,2),cex=1)
bar.err(out$means,variation="std",horiz=TRUE,xlim=c(0,45),angle=125,density=6,
 main="Standard deviation")
bar.err(out$means,variation="SE",horiz=TRUE,xlim=c(0,45),density=8,
 col="brown",main="Standard error")
bar.err(out$means,variation="rank",ylim=c(0,45),bar=FALSE,col="green",
 main="rank")
bar.err(out$means,variation="SE",ylim=c(0,45),col=colors()[30],
 main="Standard error")
par(mfrow=c(1,1))
#endgraph
}
\keyword{ aplot }% at least one, from doc/KEYWORDS

