% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplePosteriorLGLFM.R
\name{samplePosteriorLGLFM}
\alias{samplePosteriorLGLFM}
\title{Sample from the Posterior Distribution of the Linear Gaussian
Feature Allocation Model}
\usage{
samplePosteriorLGLFM(
  featureAllocation,
  distribution,
  X,
  precisionX,
  precisionA,
  sdX = 1/sqrt(precisionX),
  sdA = 1/sqrt(precisionA),
  massPriorShape = -1,
  massPriorRate = -1,
  nPerShuffle = 0L,
  temperaturePriorShape = -1,
  temperaturePriorRate = -1,
  maxStandardDeviationX = sd(X),
  maxStandardDeviationA = maxStandardDeviationX,
  sdProposedTemperature = -1,
  sdProposedStandardDeviationX = -1,
  sdProposedStandardDeviationA = -1,
  corProposedSdXSdA = 0,
  newFeaturesTruncationDivisor = 1000,
  nOtherUpdatesPerAllocationUpdate = 10L,
  nSamples = 1L,
  thin = 1L,
  rankOneUpdates = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{featureAllocation}{An N-by-K binary feature allocation matrix.}

\item{distribution}{A prior distribution of feature allocations, i.e., a
result from \code{\link{ibp}} or \code{\link{aibd}}.}

\item{X}{An N-by-D matrix of observed data.}

\item{precisionX}{The scalar precision of the data error variance.  This must
be specified if \code{sdX} is missing.}

\item{precisionA}{The scalar precision of a latent feature.  This must be
specified if \code{sdA} is missing.}

\item{sdX}{The scalar standard deviation of the data error variance.  This
must be specified if \code{precisionX} is missing.}

\item{sdA}{The scalar precision of a latent feature.  This must be specified
if \code{precisionA} is missing.}

\item{massPriorShape}{Shape parameter of the gamma prior on the mass
parameter, where the prior expected value is \code{massPriorShape/massPriorRate}.
If either \code{massPriorShape} or \code{massPriorRate} is set to \code{-1}, then the
mass parameter is assumed to be fixed (as defined in the \code{\link{aibd}} object).}

\item{massPriorRate}{Rate parameter of the gamma prior on the mass parameter,
where the expected value if \code{massPriorShape/massPriorRate}.}

\item{nPerShuffle}{Number of items to randomly select and permute when
proposing an update to the permutation associated with the attraction
Indian buffet distribution (AIBD).}

\item{temperaturePriorShape}{Shape parameter of the gamma prior on the temperature
parameter, where the prior expected value is \code{temperaturePriorShape/temperaturePriorRate}.
If either \code{temperaturePriorShape} or \code{temperaturePriorRate} is set to \code{-1}, then the
temperature parameter is assumed to be fixed (as defined in the \code{\link{aibd}} object).}

\item{temperaturePriorRate}{Rate parameter of the gamma prior on the temperature
parameter, where the prior expected value is \code{temperaturePriorShape/temperaturePriorRate}.}

\item{maxStandardDeviationX}{Maximum value parameter of the uniform prior
distribution on the standard deviation of \code{X}.}

\item{maxStandardDeviationA}{Maximum value parameter of the uniform prior
distribution on the standard deviation of \code{A}.}

\item{sdProposedTemperature}{Standard deviation of the Gaussian random
walk update for the standard deviation of the temperature.}

\item{sdProposedStandardDeviationX}{Standard deviation of the Gaussian random
walk update for the standard deviation of \code{X}.}

\item{sdProposedStandardDeviationA}{Standard deviation of the Gaussian random
walk update for the standard deviation of \code{A}.}

\item{corProposedSdXSdA}{Correlation of the multivariate Gaussian random walk
updates for the standard deviations of \code{X} and \code{A}.}

\item{newFeaturesTruncationDivisor}{While in theory a countable infinite
number of new features may be allocated to an item, the posterior
simulation needs to limit the number of new features that are considered.
The value of this argument controls when to stop considering additional
features.  Starting with 0 and 1 new features, the posterior
probabilities are computed.  Additional new features are considered but
the algorithm stops when the posterior probabilities of the current number
of new features is less than the maximum posterior probability (among the
previous number of new features) divided by
\code{newFeaturesTruncationDivisior}.}

\item{nOtherUpdatesPerAllocationUpdate}{This parameter controls how many additional
MCMC updates occur for all other random model parameters for one update of the
\code{featureAllocation} matrix.  Using values of \code{nOtherUpdatesPerAllocationUpdate > 1}
will presumably improving the mixing of the MCMC with relatively minimal computational cost.}

\item{nSamples}{Number of feature allocations to return.  The actual number
of iterations of the algorithm is \code{thin*nSamples}.}

\item{thin}{Only save 1 in \code{thin} feature allocations.}

\item{rankOneUpdates}{Should rank one updates for the inverse and determinant
be used? In some cases, this may be faster.}

\item{verbose}{Should a progress bar and information regarding lapse time and
acceptance rates be displayed?}
}
\description{
This function samples from the posterior distribution of the linear Gaussian
latent feature model (LGLFM) using an Indian buffet process (IBP) or an
Attraction Indian Buffet Distribution (AIBD) prior over possible
feature allocations.
}
\examples{
\donttest{ # Regardless of size, the initial warmup can exceed CRAN's 5 seconds threshold
mass <- 1
sigx <- 0.1
siga <- 1.0
dimA <- 1
nItems <- 8
dist <- ibp(mass, nItems)
Z <- matrix(c(1,0,1,1,0,1,0,0),byrow=TRUE,nrow=nItems,ncol=2)
A <- matrix(rnorm(ncol(Z)*dimA,sd=siga),nrow=ncol(Z),ncol=dimA)
e <- rnorm(nrow(Z)*ncol(A),0,sd=sigx)
X <- Z \%*\% A + e
samples <- samplePosteriorLGLFM(Z, dist, X, sdX=sigx, sdA=siga, nSamples=1000, thin=1)
}

}
