% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/year.R
\docType{methods}
\name{as_decimal}
\alias{as_decimal}
\alias{as_decimal-method}
\alias{as_decimal,numeric,numeric,numeric,TimeScale-method}
\title{Converts a Date to a Decimal of its Year}
\usage{
as_decimal(year, month, day, calendar)

\S4method{as_decimal}{numeric,numeric,numeric,TimeScale}(year, month, day, calendar)
}
\arguments{
\item{year}{A \code{\link{numeric}} vector of years. If \code{month} and \code{day} are missing,
decimal years are expected.}

\item{month}{A \code{\link{numeric}} vector of months.}

\item{day}{A \code{\link{numeric}} vector of days.}

\item{calendar}{A \code{\linkS4class{TimeScale}} object specifying the calendar of
\code{year}, \code{month} and \code{day} (see \code{\link[=calendar]{calendar()}}).}
}
\value{
A \code{\link{numeric}} vector of (ecimal years.
}
\description{
Converts a Date to a Decimal of its Year
}
\examples{
## R 1.0.0
(y <- fixed(year = 2000, month = 02, day = 29, calendar = CE()))
as_date(y, calendar = CE())
as_year(y, calendar = CE())

## Create a vector of years BP (Gregorian)
## (every two years starting from 2000 BP)
(years <- seq(from = 2000, by = -2, length.out = 10))
## Convert years to rata die
(rd <- fixed(years, calendar = BP()))
## Convert back to Gregorian years BP
as_year(rd, calendar = BP())

## More convenient
(rd <- fixed_from_BP(years))
fixed_to_BP(rd)
}
\seealso{
Other fixed date tools: 
\code{\link{arithmetic}},
\code{\link{as_date}()},
\code{\link{as_fixed}()},
\code{\link{as_year}()},
\code{\link{fixed}()},
\code{\link{fixed_gregorian}},
\code{\link{fixed_julian}},
\code{\link{format}()},
\code{\link{pretty}()}
}
\author{
N. Frerebeau
}
\concept{fixed date tools}
