% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{kappa4NLSobj}
\alias{kappa4NLSobj}
\alias{kappa4NLScon}
\alias{kappa4NLShin}
\alias{kappa4NLSheq}
\alias{kappa4ALobj}
\alias{kappa4ALcon}
\alias{kappa4ALhin}
\alias{kappa4ALheq}
\title{Sigmoidal curve fitting.}
\usage{
kappa4NLSobj(parms, xvec, y, x_min, x_max)

kappa4NLScon(parms, xvec, y, x_min, x_max)

kappa4NLShin(parms, xvec, y, x_min, x_max)

kappa4NLSheq(parms, xvec, y, x_min, x_max)

kappa4ALobj(parms, al_samp, x_min, x_max, q1, q2)

kappa4ALcon(parms, al_samp, x_min, x_max, q1, q2)

kappa4ALhin(parms, al_samp, x_min, x_max, q1, q2)

kappa4ALheq(parms, al_samp, x_min, x_max, q1, q2)
}
\arguments{
\item{parms}{A numeric vector of parameters to be estimated.}

\item{xvec}{A numeric vector of independent observations.}

\item{y}{A numeric vector of dependent observations.}

\item{x_min}{The minimum xvec value.}

\item{x_max}{The maximum xvec value.}

\item{al_samp}{The sample arc length statistic.}

\item{q1, q2}{Numeric vectors, for the lower and upper bounds of the intervals over which arc lengths are to be computed.}
}
\value{
kappa4NLSobj: The nonlinear least squares objective function.

kappa4NLScon: A vector with three conditions evaluated.

kappa4NLShin: A vector specifying a single nonlinear inequality constraint.

kappa4NLSheq: A vector specifying two nonlinear equality constraints.

kappa4ALobj: The arc length objective function.

kappa4ALcon: A vector with three conditions evaluated.

kappa4ALhin: A vector specifying a single nonlinear inequality constraint.

kappa4ALheq: A vector specifying two nonlinear equality constraints.
}
\description{
Support functions for fitting four-parameter kappa sigmoidal curves.
}
