% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/alEtest.R
\name{alEdist}
\alias{alEdist}
\alias{alEtest}
\alias{alEtest.default}
\alias{print.alEtest}
\title{Arc length estimation.}
\usage{
alEdist(n, bootstraps, mu, sigma, q1, q2, quantile, dc, type)

alEtest(X, mu, sigma, q1, q2, type, bootstraps, ...)

\method{alEtest}{default}(X, mu, sigma, q1, q2, type, bootstraps, ...)

\method{print}{alEtest}(x, ...)
}
\arguments{
\item{n}{An integer specifying the sample size.}

\item{bootstraps}{An integer specifying the size of the parametric bootstrap.}

\item{mu}{A real value specifying the mean of the normal distribution.}

\item{sigma}{A positive real number specifying the scale parameter of the normal distribution.}

\item{q1, q2}{Vectors specifying the quantiles (or points if quantile=FALSE) over which arc length segments are to be computed.}

\item{quantile}{TRUE/FALSE whether q1 and q2 are quantiles, or elements of the domain of \code{x}.}

\item{dc}{TRUE/FALSE:  Should the discrete or continuous sample statistic be used.}

\item{type}{The type of bandwidth estimator for the underlying KDE; see \code{\link{bw}}.}

\item{X}{A vector of sample values.}

\item{...}{Additional arguments passed to \code{alEtest} (not currently used).}

\item{x}{An alEtest object.}
}
\value{
alEdist: A vector (matrix) of arc lengths over the specified interval(s), i.e. the simulated distribution for the chosen sample arc length statistic.

alEtest: A generic S3 object with class alEtest.

alEtest.default: A list with the following components:
\itemize{
\item q1, q2: The segment over which the arc length was calculated.
\item mu: A real value specifying the mean of the normal distribution.
\item sigma: A positive real number specifying the scale parameter of the normal distribution.
\item bw: The bandwidth for the kernel density estimator.
\item dist: A numeric matrix whose columns represent a bootstrap distribution for the corresponding sample arc length statistic.
\item statistic: The value of the observed sample statistic.
\item pvalue: The p-value for the test based on a parametric bootstrap sample.
\item bootstraps: Number of bootstrap samples.
}
}
\description{
Goodness-of-fit using arc lengths.
}
\details{
First the distributional parameters of a sample is estimated using the continuous arc length sample statistic (see \code{\link{alE}}).  The calculated sample arc length statistic is then compared to the distribution of that particular sample statistic, obtained by a parametric bootstrap, using the estimated parameters (see \code{\link{alEdist}}).  This finally leads to the calculation of a p-value for a goodness-of-fit test, based on the simulated distribution.

This method is currently only implemented for the normal distribution, and for a single arc length segment.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: default method for alEtest.

\item \code{alEtest}: print method for alEtest.
}}

\examples{
\dontrun{
alEdist(50, 100, 2, 3.5, 0.025, 0.975, TRUE, TRUE, -1)
alEdist(50, 100, 2, 3.5, c(0.025,0.5), c(0.5,0.975), TRUE, TRUE, -1)
alEdist(50, 100, 2, 3.5, 0.025, 0.975, TRUE, FALSE, -1)
alEdist(50, 100, 2, 3.5, c(0.025,0.5), c(0.5,0.975), TRUE, FALSE, -1)
alEdist(50, 100, 2, 3.5, qnorm(0.025,2,3.5),
qnorm(0.975, 2, 3.5), FALSE, FALSE, -1)
alEdist(50, 100, 2, 3.5, c(qnorm(0.025, 2, 3.5),2),
c(2,qnorm(0.975, 2, 3.5)), FALSE, FALSE, -1)
}
\dontrun{
x <- rnorm(1000)
s1 <- alE(x, 0.025, 0.975, TRUE, -1)
alEtest(x, mu=s1$par[1], sigma=s1$par[2], q1=0.025, q2=0.975,
type=-1, bootstraps=50)
s2 <- alE(x, 0.025, 0.975, FALSE, -1)
alEtest(x, mu=s2$par[1], sigma=s2$par[2], q1=0.025, q2=0.975,
type=-1, bootstraps=50)
}

}
