% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_cox.R
\name{all_cox}
\alias{all_cox}
\title{Estimates all possible effect estimates using Cox Proportional Hazards regression models}
\usage{
all_cox(crude, xlist, data, na_omit = TRUE, ...)
}
\arguments{
\item{crude}{An object of \emph{formula} for initial model, generally crude model.
However, any other variables can also be included here as the initial model.
The left-hand side of ~ is the outcome of interest, and the variable on the
right-hand side of ~ is the exposure of the interest (either a treatment or a risk factor)}

\item{xlist}{A \emph{vector} of a list of variable names.}

\item{data}{\emph{Data frame}.}

\item{na_omit}{Remove all missing values. Default is \code{"na_omit = TRUE"}.}

\item{...}{Further optional arguments.}
}
\value{
A list of all effect estimates.
}
\description{
Estimates hazard ratios using Proportional Hazards Regression models
(\code{"coxph"} from \pkg{survival} package) from models with all
possible combinations of a list of variables.
}
\examples{
\dontrun{
vlist <- c("Age", "Sex", "BMI", "Education", "Income")
results <- all_cox(crude = "Surv(t0, t1, Endpoint) ~ Diabetes", xlist = vlist, data = diab_df)
results
}
}
\seealso{
\code{surival}
}
