% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_glm.R
\name{all_glm}
\alias{all_glm}
\title{Estimates all possible effect estimates using \code{glm}}
\usage{
all_glm(crude, xlist, data, family = "binomial", na_omit = TRUE, ...)
}
\arguments{
\item{crude}{An object of \emph{formula} for initial model, generally crude model.
However, any other variables can also be included here as the initial model.}

\item{xlist}{A \emph{vector} of a list of variable names (potential confounding factors).}

\item{data}{\emph{Data frame}.}

\item{family}{\emph{family} Description of the error distribution. Default is \code{"binomial"}.}

\item{na_omit}{Remove all missing values. Default is \code{"na_omit = TRUE"}.}

\item{...}{Further optional arguments.}
}
\value{
A list of all effect estimates.
}
\description{
\code{all_glm} estimates odds ratios or rate ratios using
generalized linear models (\code{glm}) with all
possible combinations of a list of variables (potential confounding factors).
}
\examples{
\dontrun{
diab_df$Overweight <- as.numeric(diab_df$BMI >= 25)
vlist <- c("Age", "Sex", "Income")
all_glm(crude = "Diabetes ~ Overweight", xlist = vlist, data = diab_df)
}
}
\seealso{
\pkg{stats}
}
