% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aou_join.R
\name{aou_join}
\alias{aou_join}
\title{Join current query to another table}
\usage{
aou_join(
  data,
  table,
  type,
  by = NULL,
  suffix = c("_x", "_y"),
  x_as = NULL,
  y_as = NULL,
  ...,
  con = getOption("aou.default.con")
)
}
\arguments{
\item{data}{unexecuted SQL query from dbplyr/dplyr.}

\item{table}{the omop table (or other remote table in your schema) you wish
to join, as a character string, or a tbl object.}

\item{type}{the type of join; types available in dplyr: "left", "right",
"inner", "anti", "full", etc.}

\item{by}{columns to join on}

\item{suffix}{suffix preferences to add when joining data with the same
column names not specified in the by argument.}

\item{x_as}{optional; a string for the name of the left table}

\item{y_as}{optional; a string for the name of the right table}

\item{...}{Additional arguments passed on to the join function}

\item{con}{Connection to the allofus SQL database. Defaults to
\code{getOption("aou.default.con")}, which is created automatically with
\code{aou_connect()}.}
}
\value{
Reference to the remote table created by the join.
}
\description{
Joins two tables in the All of Us database. A less verbose
wrapper for the dplyr::*_join() functions with some added safeguards.
}
\details{
There are a few good reasons to use aou_join() when possible over
the x_join functions from dplyr. First, it reduces the code necessary to join
an existing table to another table. Second, it includes checks/workarounds
for two sources of common errors using dbplyr: it automatically appends the
x_as and y_as arguments to the join call if they are not provided and it
changes the default suffix from .x/.y to _x/_y for cases with shared column
names not specified by the \code{by} argument which will result in a SQL error.
}
\examples{
\dontshow{if (on_workbench()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

con <- aou_connect()
obs_tbl <- dplyr::tbl(con, "observation") \%>\%
  dplyr::select(-provider_id)
obs_tbl \%>\%
  aou_join("person", type = "left", by = "person_id")
\dontshow{\}) # examplesIf}
}
