% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recur-on-wday.R
\name{recur_on_wday}
\alias{recur_on_wday}
\alias{recur_on_weekdays}
\alias{recur_on_weekends}
\title{Recur on a day of the week}
\usage{
recur_on_wday(x, wday, nth = NULL)

recur_on_weekdays(x)

recur_on_weekends(x)
}
\arguments{
\item{x}{\verb{[rrule]}

A recurrence rule.}

\item{wday}{\verb{[integer / character]}

Days of the week to recur on. Integer values must be from \code{1} to \code{7}, with
\code{1 = Monday} and \code{7 = Sunday}. This is also allowed to be a full weekday
string like \code{"Tuesday"}, or an abbreviation like \code{"Tues"}.}

\item{nth}{\verb{[integer / NULL]}

Limit to the n-th occurrence of the \code{wday} in the base frequency. For
example, in a monthly frequency, using \code{nth = -1} would limit to the
last \code{wday} in the month. The default of \code{NULL} chooses all occurrences.}
}
\value{
An updated rrule.
}
\description{
\itemize{
\item \code{recur_on_wday()} recurs on a specific day of the week.
\item \code{recur_on_weekends()} and \code{recur_on_weekdays()} are helpers for
recurring on weekends and weekdays.
}
}
\details{
Multiple week day values are allowed, and \code{nth} will be applied to
all of them. If you want to apply different \code{nth} values to different
days of the week, call \code{recur_on_wday()} twice with different \code{wday} values.

It is particularly important to pay attention to the \code{since} date when using
weekly rules. The day of the week to use comes from the \code{since} date, which,
by default, is a Monday (\code{1900-01-01}).
}
\examples{
# Using default `since` (1900-01-01, a Monday)
on_weekly_mondays <- weekly()

start <- "1999-01-01" # <- a Friday
end <- "1999-03-01"

# This finds the first Thursday, and then continues from there
alma_search(start, end, on_weekly_mondays)

# We start counting from a Friday here
on_weekly_fridays <- weekly(since = start)
alma_search(start, end, on_weekly_fridays)

# Alternatively, we could use `recur_on_wday()` and force a recurrence rule
# on Friday
on_wday_friday <- on_weekly_mondays \%>\% recur_on_wday("Friday")
alma_search(start, end, on_wday_friday)

# At monthly frequencies, you can use n-th values to look for particular
# week day events
on_first_friday_in_month <- monthly() \%>\% recur_on_wday("Fri", 1)
alma_search(start, end, on_first_friday_in_month)

# Negative values let you look from the back
on_last_friday_in_month <- monthly() \%>\% recur_on_wday("Fri", -1)
alma_search(start, end, on_last_friday_in_month)

# At yearly frequencies, this looks for the first sunday of the year
on_first_sunday_in_year <- yearly() \%>\% recur_on_wday("Sunday", 1)
alma_search(start, end, on_first_sunday_in_year)

# Last week day of the month
last_weekday_of_month <- monthly() \%>\%
  # Last occurrence of each weekday in the month
  recur_on_wday(c("Mon", "Tue", "Wed", "Thu", "Fri"), -1) \%>\%
  # Now choose the last one of those in each month
  recur_on_position(-1)

alma_search(start, end, last_weekday_of_month)

}
