% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rbeta_ab_fc.R
\name{rbeta_ab_fc}
\alias{rbeta_ab_fc}
\title{Gibbs sampling of additive row and column effects and regression coefficient}
\usage{
rbeta_ab_fc(Z, Sab, rho, X, mX, mXt, XX, XXt, Xr, Xc, s2 = 1)
}
\arguments{
\item{Z}{n X n (latent) normal relational matrix, with multiplicative
effects subtracted out}

\item{Sab}{row and column covariance}

\item{rho}{dyadic correlation}

\item{X}{n x n x p covariate array}

\item{mX}{design matrix (matricizied version of X)}

\item{mXt}{dyad-transposed design matrix}

\item{XX}{regression sums of squares}

\item{XXt}{crossproduct sums of squares}

\item{Xr}{row sums for X}

\item{Xc}{column sums for X}

\item{s2}{dyadic variance}
}
\value{
\item{beta}{regression coefficients} \item{a}{additive row effects}
\item{b}{additive column effects}
}
\description{
Simulates from the joint full conditional distribution of (a,b,beta)
}
\author{
Peter Hoff
}

