% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raSab_bin_fc.R
\name{raSab_bin_fc}
\alias{raSab_bin_fc}
\title{Simulate a and Sab from full conditional distributions under bin likelihood}
\usage{
raSab_bin_fc(Z, Y, a, b, Sab, Sab0=NULL, eta0=NULL, SS = round(sqrt(nrow(Z))))
}
\arguments{
\item{Z}{a square matrix, the current value of Z}

\item{Y}{square binary relational matrix}

\item{a}{current value of row effects}

\item{b}{current value of column effects}

\item{Sab}{current value of Cov(a,b)}

\item{Sab0}{prior (inverse) scale matrix for the prior distribution}

\item{eta0}{prior degrees of freedom for the prior distribution}

\item{SS}{number of iterations}
}
\value{
\item{Z}{new value of Z} \item{Sab}{new value of Sab} \item{a}{new
value of a}
}
\description{
Simulate a and Sab from full conditional distributions under bin likelihood
}
\author{
Peter Hoff
}
