% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/images.R
\name{as.image}
\alias{as.image}
\alias{image}
\alias{images}
\title{Get list of images and their metadata, or a single image}
\usage{
as.image(x)

images(private = FALSE, type = NULL, page = 1, per_page = 25,
  public = TRUE, ...)

image(id, ...)
}
\arguments{
\item{x}{Object to coerce to an image.}

\item{private}{Include public images? If \code{FALSE}, returns only the
images that you've created (with snapshots).}

\item{type}{(character) One of \code{distribution} or \code{application}.
Default: NULL (no type parameter passed)}

\item{page}{Page to return. Default: 1.}

\item{per_page}{Number of results per page. Default: 25.}

\item{public}{Include public images? If \code{FALSE}, returns only the
images that you've created (with snapshots).}

\item{...}{Additional arguments passed down to low-level API function
(\code{do_*})}

\item{id}{(numeric) Image id.}
}
\description{
Get list of images and their metadata, or a single image
}
\examples{
\dontrun{
images()

# list private images
images(private = TRUE)

# list by type
images(type = "distribution")
images(type = "application")

# paging
images(per_page = 3)
images(per_page = 3, page = 2)
}
}

