% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{getReplacementNames}
\alias{getReplacementNames}
\title{getReplacementNames}
\usage{
getReplacementNames(auth, account.name)
}
\arguments{
\item{auth}{Authentication instance. result of \code{\link{authenticate}} function}

\item{account.name}{Name of the account for which to get metadata (column \code{acct.name} from the result of the function \code{getAccountInfo})}
}
\value{
dataframe with the column names of the variables that have a replacement name in the UI, along with the associated table and datasuite. NA is no column names has replacement names.
}
\description{
Get all replacement names associated to an account. Replacement names are column names displayed in the tables in the UI that were not the original names defined.
}
\examples{
username <- "demo.user@demoanametrix.com"
password <- "password"
if (!authenticationCheck(auth)) 
auth <- authenticate("https://demo.anametrix.com/api", username, password)
rep.names.df <- getReplacementNames(auth, account.name = "Demo")

}
\seealso{
Other metadata functions: \code{\link{getAccountInfo}},
  \code{\link{getDatasuiteInfo}},
  \code{\link{getDetailedInfo}},
  \code{\link{getSegmentInfo}}, \code{\link{getTableInfo}},
  \code{\link{getVariableInfo}}
}

