% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_3d.R
\name{auto_3d}
\alias{auto_3d}
\title{Auto aspect ratio}
\usage{
auto_3d(...)
}
\arguments{
\item{...}{unused, check for input of arguments which are ignored with a message}
}
\value{
the original value of \code{\link[rgl:par3d]{rgl::par3d()}} before update
}
\description{
Automatically modify the aspect ratio of a scene to
rescale drastically different data ranges into a cube.
}
\details{
This is a simple alias to \link[rgl:aspect3d]{rgl::aspect3d(1)}.

This is typically used to rescale data in different units, for example
longitude and latitude in degrees and elevation in metres.

Note that running \code{rgl::aspect3d("iso")} which show the realistic ratio of
the plot axes, ignoring units. Running this function is equivalent to
\code{rgl::aspectd(1)} (or \code{rgl::aspect(x = 1, y = 1, z = 1)}) which sets the
\emph{apparent} ratios of the current bounding box.
}
\examples{
topo <- copy_down(silicate::SC(simpleworld), gebco)
plot3d(topo)
## update aspect ratio to be an apparent cube, not a needle
auto_3d()
}
