% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addExportAndImport.R
\name{addExportAndImport}
\alias{addExportAndImport}
\title{Export and import of areas or districts}
\usage{
addExportAndImport(x, addCapacities = FALSE)
}
\arguments{
\item{x}{an object of class "antaresDataList" created with the function
\code{readAntares}. It has to contain some areas and all the links that are
connected to these areas. Moreover the function \code{\link{removeVirtualAreas}} must be call before.}

\item{addCapacities}{If \code{TRUE}, export and import capacities are added.}
}
\description{
This function computes the export and import of areas or districts and add it to an
\code{antaresData} object.
}
\examples{
\dontrun{
# Data required by the function
showAliases("exportsImports")

mydata <- readAntares(select = "exportsImports")
addExportAndImport(mydata)
names(mydata$areas)

}
}
